-- Adminer 4.8.0 MySQL 5.5.5-10.4.17-MariaDB dump

SET NAMES utf8;
SET time_zone = '+00:00';
SET foreign_key_checks = 0;
SET sql_mode = 'NO_AUTO_VALUE_ON_ZERO';

SET NAMES utf8mb4;

DROP TABLE IF EXISTS `qd_authors`;
CREATE TABLE `qd_authors` (
  `admin_id` int(11) unsigned NOT NULL,
  `editor` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `lev` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `files_level` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `position` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `main_module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'siteinfo',
  `admin_theme` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `addtime` int(11) NOT NULL DEFAULT 0,
  `edittime` int(11) NOT NULL DEFAULT 0,
  `is_suspend` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `susp_reason` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `pre_check_num` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `pre_last_login` int(11) unsigned NOT NULL DEFAULT 0,
  `pre_last_ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `pre_last_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `check_num` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `last_login` int(11) unsigned NOT NULL DEFAULT 0,
  `last_ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `last_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`admin_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_authors`;
INSERT INTO `qd_authors` (`admin_id`, `editor`, `lev`, `files_level`, `position`, `main_module`, `admin_theme`, `addtime`, `edittime`, `is_suspend`, `susp_reason`, `pre_check_num`, `pre_last_login`, `pre_last_ip`, `pre_last_agent`, `check_num`, `last_login`, `last_ip`, `last_agent`) VALUES
(1,	'ckeditor',	1,	'adobe,archives,audio,documents,flash,images,real,video|1|1|1',	'Administrator',	'siteinfo',	'',	0,	0,	0,	'',	'',	0,	'',	'',	'd3ed428e819c35a0e89fb7b3a7668055',	1629363956,	'127.0.0.1',	'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.159 Safari/537.36');

DROP TABLE IF EXISTS `qd_authors_config`;
CREATE TABLE `qd_authors_config` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `keyname` varchar(39) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `mask` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `begintime` int(11) unsigned NOT NULL DEFAULT 0,
  `endtime` int(11) unsigned NOT NULL DEFAULT 0,
  `notice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `keyname` (`keyname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_authors_config`;

DROP TABLE IF EXISTS `qd_authors_module`;
CREATE TABLE `qd_authors_module` (
  `mid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_key` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `weight` mediumint(8) NOT NULL DEFAULT 0,
  `act_1` tinyint(4) NOT NULL DEFAULT 0,
  `act_2` tinyint(4) NOT NULL DEFAULT 1,
  `act_3` tinyint(4) NOT NULL DEFAULT 1,
  `checksum` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`mid`),
  UNIQUE KEY `module` (`module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_authors_module`;
INSERT INTO `qd_authors_module` (`mid`, `module`, `lang_key`, `weight`, `act_1`, `act_2`, `act_3`, `checksum`) VALUES
(1,	'siteinfo',	'mod_siteinfo',	1,	1,	1,	1,	'0d7f51dd4444d56395aad7f94dff5f55'),
(2,	'authors',	'mod_authors',	2,	1,	1,	1,	'4b3dbfdd21e6a75f43aaaebb790c37eb'),
(3,	'settings',	'mod_settings',	3,	1,	1,	0,	'6ce927370db8b9c0de84d291a4a350d3'),
(4,	'database',	'mod_database',	4,	1,	0,	0,	'474184bd3c1d4ee2855065ee8f105a2d'),
(5,	'webtools',	'mod_webtools',	5,	1,	1,	0,	'3dcb46c2ec7934cc1b2dfa25fcfa007a'),
(6,	'seotools',	'mod_seotools',	6,	1,	1,	0,	'9941a06f043b8a18b70272d38ccc7e23'),
(7,	'language',	'mod_language',	7,	1,	1,	0,	'8c0aca20dd73ac57912d7fd2f1fa283c'),
(8,	'modules',	'mod_modules',	8,	1,	1,	0,	'ebb3322fdab1cc8b89f28c1745026faa'),
(9,	'themes',	'mod_themes',	9,	1,	1,	0,	'bf210995616028ba8e5988eb9460e2b7'),
(10,	'extensions',	'mod_extensions',	10,	1,	0,	0,	'97f4cc3b0dfb20591d0d0b5dbe5e1c16'),
(11,	'upload',	'mod_upload',	11,	1,	1,	1,	'caa7f59e3378a7617bbbb44721d6424c');

DROP TABLE IF EXISTS `qd_authors_oauth`;
CREATE TABLE `qd_authors_oauth` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `admin_id` int(11) unsigned NOT NULL COMMENT 'ID của quản trị',
  `oauth_server` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Eg: facebook, google...',
  `oauth_uid` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'ID duy nhất ứng với server',
  `oauth_email` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Email',
  `addtime` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `admin_id` (`admin_id`,`oauth_server`,`oauth_uid`),
  KEY `oauth_email` (`oauth_email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Bảng lưu xác thực 2 bước từ oauth của admin';

TRUNCATE `qd_authors_oauth`;

DROP TABLE IF EXISTS `qd_banners_click`;
CREATE TABLE `qd_banners_click` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `bid` mediumint(8) NOT NULL DEFAULT 0,
  `click_time` int(11) unsigned NOT NULL DEFAULT 0,
  `click_day` int(2) NOT NULL,
  `click_ip` varchar(46) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_country` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_browse_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_browse_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_os_key` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_os_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `click_ref` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `bid` (`bid`),
  KEY `click_day` (`click_day`),
  KEY `click_ip` (`click_ip`),
  KEY `click_country` (`click_country`),
  KEY `click_browse_key` (`click_browse_key`),
  KEY `click_os_key` (`click_os_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_banners_click`;

DROP TABLE IF EXISTS `qd_banners_plans`;
CREATE TABLE `qd_banners_plans` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `blang` char(2) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `form` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` smallint(4) unsigned NOT NULL DEFAULT 0,
  `height` smallint(4) unsigned NOT NULL DEFAULT 0,
  `act` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `require_image` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `uploadtype` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `uploadgroup` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `exp_time` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_banners_plans`;
INSERT INTO `qd_banners_plans` (`id`, `blang`, `title`, `description`, `form`, `width`, `height`, `act`, `require_image`, `uploadtype`, `uploadgroup`, `exp_time`) VALUES
(1,	'',	'Quang cao giua trang',	'',	'sequential',	575,	72,	1,	1,	'images',	'',	0),
(2,	'',	'Quang cao trai',	'',	'sequential',	212,	800,	1,	1,	'images',	'',	0),
(3,	'',	'Quang cao Phai',	'',	'random',	250,	500,	1,	1,	'images',	'',	0);

DROP TABLE IF EXISTS `qd_banners_rows`;
CREATE TABLE `qd_banners_rows` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pid` smallint(5) unsigned NOT NULL DEFAULT 0,
  `clid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `file_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_ext` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_mime` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `width` int(4) unsigned NOT NULL DEFAULT 0,
  `height` int(4) unsigned NOT NULL DEFAULT 0,
  `file_alt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `imageforswf` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `click_url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `target` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_blank',
  `bannerhtml` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `add_time` int(11) unsigned NOT NULL DEFAULT 0,
  `publ_time` int(11) unsigned NOT NULL DEFAULT 0,
  `exp_time` int(11) unsigned NOT NULL DEFAULT 0,
  `hits_total` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `act` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `weight` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `pid` (`pid`),
  KEY `clid` (`clid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_banners_rows`;
INSERT INTO `qd_banners_rows` (`id`, `title`, `pid`, `clid`, `file_name`, `file_ext`, `file_mime`, `width`, `height`, `file_alt`, `imageforswf`, `click_url`, `target`, `bannerhtml`, `add_time`, `publ_time`, `exp_time`, `hits_total`, `act`, `weight`) VALUES
(2,	'vinades',	2,	1,	'vinades.jpg',	'jpg',	'image/jpeg',	212,	400,	'',	'',	'http://vinades.vn',	'_blank',	'',	1596205058,	1596205058,	0,	0,	1,	2),
(3,	'Quang cao giua trang',	1,	1,	'webnhanh.jpg',	'png',	'image/jpeg',	575,	72,	'',	'',	'http://webnhanh.vn',	'_blank',	'',	1596205058,	1596205058,	0,	0,	1,	1);

DROP TABLE IF EXISTS `qd_config`;
CREATE TABLE `qd_config` (
  `lang` varchar(3) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'sys',
  `module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'global',
  `config_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `config_value` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `lang` (`lang`,`module`,`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_config`;
INSERT INTO `qd_config` (`lang`, `module`, `config_name`, `config_value`) VALUES
('sys',	'site',	'closed_site',	'0'),
('sys',	'site',	'admin_theme',	'admin_default'),
('sys',	'site',	'date_pattern',	'l, d/m/Y'),
('sys',	'site',	'time_pattern',	'H:i'),
('sys',	'site',	'online_upd',	'1'),
('sys',	'site',	'statistic',	'1'),
('sys',	'site',	'site_phone',	'0866628896'),
('sys',	'site',	'mailer_mode',	'smtp'),
('sys',	'site',	'smtp_host',	''),
('sys',	'site',	'smtp_ssl',	'1'),
('sys',	'site',	'smtp_port',	''),
('sys',	'site',	'verify_peer_ssl',	'0'),
('sys',	'site',	'verify_peer_name_ssl',	'0'),
('sys',	'site',	'smtp_username',	''),
('sys',	'site',	'smtp_password',	'ACLVsAV7uwRSkK-FwTKUnQ,,'),
('sys',	'site',	'sender_name',	''),
('sys',	'site',	'sender_email',	''),
('sys',	'site',	'reply_name',	''),
('sys',	'site',	'reply_email',	''),
('sys',	'site',	'force_sender',	'1'),
('sys',	'site',	'force_reply',	'1'),
('sys',	'site',	'notify_email_error',	'1'),
('sys',	'site',	'googleAnalyticsID',	'UA-69092700-4'),
('sys',	'site',	'googleAnalyticsSetDomainName',	'0'),
('sys',	'site',	'googleAnalyticsMethod',	'classic'),
('sys',	'site',	'searchEngineUniqueID',	''),
('sys',	'site',	'metaTagsOgp',	'1'),
('sys',	'site',	'pageTitleMode',	'pagetitle | sitename'),
('sys',	'site',	'description_length',	'170'),
('sys',	'site',	'nv_unickmin',	'3'),
('sys',	'site',	'nv_unickmax',	'20'),
('sys',	'site',	'nv_upassmin',	'8'),
('sys',	'site',	'nv_upassmax',	'32'),
('sys',	'site',	'dir_forum',	''),
('sys',	'site',	'nv_unick_type',	'4'),
('sys',	'site',	'nv_upass_type',	'3'),
('sys',	'site',	'allowmailchange',	'1'),
('sys',	'site',	'allowuserpublic',	'1'),
('sys',	'site',	'allowquestion',	'0'),
('sys',	'site',	'allowloginchange',	'0'),
('sys',	'site',	'allowuserlogin',	'1'),
('sys',	'site',	'allowuserloginmulti',	'0'),
('sys',	'site',	'allowuserreg',	'2'),
('sys',	'site',	'is_user_forum',	'0'),
('sys',	'site',	'openid_servers',	''),
('sys',	'site',	'openid_processing',	'0'),
('sys',	'site',	'user_check_pass_time',	'1800'),
('sys',	'site',	'auto_login_after_reg',	'1'),
('sys',	'site',	'whoviewuser',	'2'),
('sys',	'site',	'ssl_https',	'0'),
('sys',	'site',	'facebook_client_id',	''),
('sys',	'site',	'facebook_client_secret',	''),
('sys',	'site',	'google_client_id',	''),
('sys',	'site',	'google_client_secret',	''),
('sys',	'site',	'referer_blocker',	'1'),
('sys',	'site',	'private_site',	'0'),
('sys',	'site',	'max_user_admin',	'0'),
('sys',	'site',	'max_user_number',	'0'),
('sys',	'define',	'nv_gfx_num',	'6'),
('sys',	'global',	'notification_active',	'1'),
('sys',	'global',	'notification_autodel',	'15'),
('sys',	'global',	'site_keywords',	'NukeViet, portal, mysql, php'),
('sys',	'global',	'block_admin_ip',	'0'),
('sys',	'global',	'admfirewall',	'0'),
('sys',	'global',	'dump_autobackup',	'1'),
('sys',	'global',	'dump_backup_ext',	'gz'),
('sys',	'global',	'dump_backup_day',	'30'),
('sys',	'global',	'gfx_chk',	'0'),
('sys',	'global',	'file_allowed_ext',	'adobe,archives,audio,documents,flash,images,real,video'),
('sys',	'global',	'forbid_extensions',	'php,php3,php4,php5,phtml,inc'),
('sys',	'global',	'forbid_mimes',	''),
('sys',	'global',	'nv_max_size',	'41943040'),
('sys',	'global',	'nv_overflow_size',	'0'),
('sys',	'global',	'upload_checking_mode',	'strong'),
('sys',	'global',	'upload_alt_require',	'1'),
('sys',	'global',	'upload_auto_alt',	'1'),
('sys',	'global',	'upload_chunk_size',	'0'),
('sys',	'global',	'useactivate',	'2'),
('sys',	'global',	'allow_sitelangs',	'vi'),
('sys',	'global',	'read_type',	'0'),
('sys',	'global',	'rewrite_enable',	'1'),
('sys',	'global',	'rewrite_optional',	'1'),
('sys',	'global',	'rewrite_endurl',	'/'),
('sys',	'global',	'rewrite_exturl',	'.html'),
('sys',	'global',	'rewrite_op_mod',	'home'),
('sys',	'global',	'autocheckupdate',	'1'),
('sys',	'global',	'autoupdatetime',	'24'),
('sys',	'global',	'gzip_method',	'1'),
('sys',	'global',	'authors_detail_main',	'0'),
('sys',	'global',	'spadmin_add_admin',	'1'),
('sys',	'global',	'timestamp',	'1629364004'),
('sys',	'global',	'captcha_type',	'0'),
('sys',	'global',	'version',	'4.4.02'),
('sys',	'global',	'cookie_httponly',	'1'),
('sys',	'global',	'admin_check_pass_time',	'1800'),
('sys',	'global',	'cookie_secure',	'0'),
('sys',	'global',	'is_flood_blocker',	'1'),
('sys',	'global',	'max_requests_60',	'40'),
('sys',	'global',	'max_requests_300',	'150'),
('sys',	'global',	'is_login_blocker',	'1'),
('sys',	'global',	'login_number_tracking',	'5'),
('sys',	'global',	'login_time_tracking',	'5'),
('sys',	'global',	'login_time_ban',	'30'),
('sys',	'global',	'nv_display_errors_list',	'1'),
('sys',	'global',	'display_errors_list',	'1'),
('sys',	'global',	'nv_auto_resize',	'1'),
('sys',	'global',	'dump_interval',	'1'),
('sys',	'global',	'cdn_url',	''),
('sys',	'global',	'two_step_verification',	'0'),
('sys',	'global',	'admin_2step_opt',	'code'),
('sys',	'global',	'admin_2step_default',	'code'),
('sys',	'global',	'recaptcha_sitekey',	''),
('sys',	'global',	'recaptcha_secretkey',	''),
('sys',	'global',	'recaptcha_type',	'image'),
('sys',	'global',	'users_special',	'0'),
('sys',	'global',	'crosssite_restrict',	'1'),
('sys',	'global',	'crosssite_valid_domains',	''),
('sys',	'global',	'crosssite_valid_ips',	''),
('sys',	'global',	'crossadmin_restrict',	'1'),
('sys',	'global',	'crossadmin_valid_domains',	''),
('sys',	'global',	'crossadmin_valid_ips',	''),
('sys',	'global',	'domains_whitelist',	'[\"youtube.com\",\"www.youtube.com\",\"google.com\",\"www.google.com\",\"drive.google.com\"]'),
('sys',	'global',	'domains_restrict',	'1'),
('sys',	'define',	'nv_gfx_width',	'150'),
('sys',	'define',	'nv_gfx_height',	'40'),
('sys',	'define',	'nv_max_width',	'1500'),
('sys',	'define',	'nv_max_height',	'1500'),
('sys',	'define',	'nv_live_cookie_time',	'31104000'),
('sys',	'define',	'nv_live_session_time',	'0'),
('sys',	'define',	'nv_anti_iframe',	'1'),
('sys',	'define',	'nv_anti_agent',	'0'),
('sys',	'define',	'nv_allowed_html_tags',	'embed, object, param, a, b, blockquote, br, caption, col, colgroup, div, em, h1, h2, h3, h4, h5, h6, hr, i, img, li, p, span, strong, s, sub, sup, table, tbody, td, th, tr, u, ul, ol, iframe, figure, figcaption, video, audio, source, track, code, pre'),
('sys',	'define',	'nv_debug',	'1'),
('vi',	'global',	'site_domain',	''),
('vi',	'global',	'site_name',	'Tiêu đề website'),
('vi',	'global',	'site_logo',	'uploads/logo-huynhquocdat.jpg'),
('vi',	'global',	'site_banner',	''),
('vi',	'global',	'site_favicon',	'uploads/favicon.ico'),
('vi',	'global',	'site_description',	'Mô tả website'),
('vi',	'global',	'site_keywords',	''),
('vi',	'global',	'theme_type',	'r'),
('vi',	'global',	'site_theme',	'huynhquocdat'),
('vi',	'global',	'preview_theme',	''),
('vi',	'global',	'user_allowed_theme',	''),
('vi',	'global',	'mobile_theme',	''),
('vi',	'global',	'site_home_module',	'home'),
('vi',	'global',	'switch_mobi_des',	'0'),
('vi',	'global',	'upload_logo',	''),
('vi',	'global',	'upload_logo_pos',	'bottomRight'),
('vi',	'global',	'autologosize1',	'50'),
('vi',	'global',	'autologosize2',	'40'),
('vi',	'global',	'autologosize3',	'30'),
('vi',	'global',	'autologomod',	''),
('vi',	'global',	'name_show',	'0'),
('vi',	'global',	'cronjobs_next_time',	'1629367164'),
('vi',	'global',	'disable_site_content',	'Vì lý do kỹ thuật website tạm ngưng hoạt động. Thành thật xin lỗi các bạn vì sự bất tiện này!'),
('vi',	'seotools',	'prcservice',	''),
('vi',	'blog',	'frontend_edit_alias',	'0'),
('vi',	'page',	'auto_postcomm',	'1'),
('vi',	'page',	'allowed_comm',	'-1'),
('vi',	'page',	'view_comm',	'6'),
('vi',	'page',	'setcomm',	'4'),
('vi',	'page',	'activecomm',	'0'),
('vi',	'page',	'emailcomm',	'0'),
('vi',	'page',	'adminscomm',	''),
('vi',	'page',	'sortcomm',	'0'),
('vi',	'page',	'captcha',	'1'),
('vi',	'page',	'perpagecomm',	'5'),
('vi',	'page',	'timeoutcomm',	'360'),
('vi',	'page',	'allowattachcomm',	'0'),
('vi',	'page',	'alloweditorcomm',	'0'),
('vi',	'blog',	'alloweditorcomm',	'0'),
('vi',	'blog',	'setcomm',	'4'),
('vi',	'blog',	'activecomm',	'1'),
('vi',	'blog',	'emailcomm',	'0'),
('vi',	'blog',	'adminscomm',	''),
('vi',	'blog',	'sortcomm',	'0'),
('vi',	'blog',	'captcha',	'0'),
('vi',	'blog',	'perpagecomm',	'5'),
('vi',	'blog',	'timeoutcomm',	'360'),
('vi',	'blog',	'allowattachcomm',	'0'),
('vi',	'blog',	'view_comm',	'6'),
('vi',	'blog',	'frontend_edit_layout',	'1'),
('sys',	'site',	'statistics_timezone',	'Asia/Bangkok'),
('sys',	'site',	'site_email',	'dat@vuta.vn'),
('sys',	'global',	'error_set_logs',	'1'),
('sys',	'global',	'error_send_email',	'hqdat.py@gmail.com'),
('sys',	'global',	'site_lang',	'vi'),
('sys',	'global',	'my_domains',	'sharequocdat.local'),
('sys',	'global',	'cookie_prefix',	'nv4'),
('sys',	'global',	'session_prefix',	'nv4s_d8SoWS'),
('sys',	'global',	'site_timezone',	'byCountry'),
('sys',	'global',	'proxy_blocker',	'0'),
('sys',	'global',	'str_referer_blocker',	'0'),
('sys',	'global',	'lang_multi',	'0'),
('sys',	'global',	'lang_geo',	'0'),
('sys',	'global',	'ftp_server',	'localhost'),
('sys',	'global',	'ftp_port',	'21'),
('sys',	'global',	'ftp_user_name',	''),
('sys',	'global',	'ftp_user_pass',	'xiLJnCZKzh6Wjw00F-6s5g,,'),
('sys',	'global',	'ftp_path',	'/'),
('sys',	'global',	'ftp_check_login',	'0'),
('vi',	'blog',	'allowed_comm',	'6'),
('vi',	'blog',	'auto_postcomm',	'1'),
('vi',	'blog',	'instant_articles_auto',	'1'),
('vi',	'blog',	'instant_articles_gettime',	'120'),
('vi',	'blog',	'instant_articles_livetime',	'60'),
('vi',	'blog',	'instant_articles_password',	''),
('vi',	'blog',	'instant_articles_username',	''),
('vi',	'blog',	'instant_articles_httpauth',	'0'),
('vi',	'blog',	'instant_articles_template',	'default'),
('vi',	'blog',	'instant_articles_active',	'0'),
('vi',	'blog',	'elas_index',	''),
('vi',	'blog',	'elas_port',	'9200'),
('vi',	'blog',	'elas_host',	''),
('vi',	'blog',	'elas_use',	'0'),
('vi',	'blog',	'identify_cat_change',	'0'),
('vi',	'blog',	'order_articles',	'0'),
('vi',	'blog',	'htmlhometext',	'0'),
('vi',	'blog',	'imgposition',	'2'),
('vi',	'blog',	'structure_upload',	'Ym'),
('vi',	'blog',	'copy_news',	'0'),
('vi',	'blog',	'keywords_tag',	'1'),
('vi',	'blog',	'tags_remind',	'1'),
('vi',	'blog',	'auto_tags',	'1'),
('vi',	'blog',	'tags_alias',	'1'),
('vi',	'blog',	'alias_lower',	'1'),
('vi',	'blog',	'socialbutton',	'1'),
('vi',	'blog',	'facebookappid',	''),
('vi',	'blog',	'allowed_rating_point',	'1'),
('vi',	'blog',	'show_no_image',	''),
('vi',	'blog',	'config_source',	'0'),
('vi',	'blog',	'timecheckstatus',	'0'),
('vi',	'blog',	'showhometext',	'1'),
('vi',	'blog',	'tooltip_length',	'125'),
('vi',	'blog',	'tooltip_position',	'bottom'),
('vi',	'blog',	'showtooltip',	'0'),
('vi',	'blog',	'copyright',	'<strong>Chú ý:</strong>&nbsp;Bài viết này thuộc bản quyền của <strong>Huỳnh Quốc Đạt</strong>, việc đăng lại bài viết trên ở website hoặc các phương tiện truyền thông khác mà không ghi rõ nguồn <strong><em>huynhquocdat.com</em></strong> là vi phạm bản quyền.'),
('vi',	'blog',	'imagefull',	'460'),
('vi',	'blog',	'blockheight',	'75'),
('vi',	'blog',	'blockwidth',	'70'),
('vi',	'blog',	'homeheight',	'150'),
('vi',	'blog',	'homewidth',	'100'),
('vi',	'blog',	'st_links',	'0'),
('vi',	'blog',	'per_page',	'6'),
('vi',	'blog',	'indexfile',	'viewcat_grid_new');

DROP TABLE IF EXISTS `qd_cookies`;
CREATE TABLE `qd_cookies` (
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `domain` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `expires` int(11) NOT NULL DEFAULT 0,
  `secure` tinyint(1) NOT NULL DEFAULT 0,
  UNIQUE KEY `cookiename` (`name`,`domain`,`path`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_cookies`;

DROP TABLE IF EXISTS `qd_counter`;
CREATE TABLE `qd_counter` (
  `c_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `c_val` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_update` int(11) NOT NULL DEFAULT 0,
  `c_count` int(11) unsigned NOT NULL DEFAULT 0,
  `vi_count` int(11) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `c_type` (`c_type`,`c_val`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_counter`;

DROP TABLE IF EXISTS `qd_cronjobs`;
CREATE TABLE `qd_cronjobs` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `start_time` int(11) unsigned NOT NULL DEFAULT 0,
  `inter_val` int(11) unsigned NOT NULL DEFAULT 0,
  `inter_val_type` tinyint(1) unsigned NOT NULL DEFAULT 0 COMMENT '0: Lặp lại sau thời điểm bắt đầu thực tế, 1:lặp lại sau thời điểm bắt đầu trong CSDL',
  `run_file` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `run_func` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `del` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `is_sys` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `act` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `last_time` int(11) unsigned NOT NULL DEFAULT 0,
  `last_result` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `vi_cron_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `is_sys` (`is_sys`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_cronjobs`;
INSERT INTO `qd_cronjobs` (`id`, `start_time`, `inter_val`, `inter_val_type`, `run_file`, `run_func`, `params`, `del`, `is_sys`, `act`, `last_time`, `last_result`, `vi_cron_name`) VALUES
(1,	1596205058,	5,	0,	'online_expired_del.php',	'cron_online_expired_del',	'',	0,	1,	1,	1629366864,	1,	'Xóa các dòng ghi trạng thái online đã cũ trong CSDL'),
(2,	1596205058,	1440,	0,	'dump_autobackup.php',	'cron_dump_autobackup',	'',	0,	1,	1,	1629351083,	1,	'Tự động lưu CSDL'),
(3,	1596205058,	60,	0,	'temp_download_destroy.php',	'cron_auto_del_temp_download',	'',	0,	1,	1,	1629366864,	1,	'Xóa các file tạm trong thư mục tmp'),
(4,	1596205058,	30,	0,	'ip_logs_destroy.php',	'cron_del_ip_logs',	'',	0,	1,	1,	1629365700,	1,	'Xóa IP log files, Xóa các file nhật ký truy cập'),
(5,	1596205058,	1440,	0,	'error_log_destroy.php',	'cron_auto_del_error_log',	'',	0,	1,	1,	1629351083,	1,	'Xóa các file error_log quá hạn'),
(6,	1596205058,	360,	0,	'error_log_sendmail.php',	'cron_auto_sendmail_error_log',	'',	0,	1,	1,	1629359253,	1,	'Gửi email các thông báo lỗi cho admin'),
(7,	1596205058,	60,	0,	'ref_expired_del.php',	'cron_ref_expired_del',	'',	0,	1,	1,	1629366864,	1,	'Xóa các referer quá hạn'),
(8,	1596205058,	60,	0,	'check_version.php',	'cron_auto_check_version',	'',	0,	1,	1,	1629366864,	1,	'Kiểm tra phiên bản NukeViet'),
(9,	1596205058,	1440,	0,	'notification_autodel.php',	'cron_notification_autodel',	'',	0,	1,	1,	1629351083,	1,	'Xóa thông báo cũ'),
(13,	1626656400,	10080,	0,	'nv_newsnotice_auto_sendmail.php',	'cron_newsnotice_start_send_mail',	'newsnotice,vi_blog_rows',	0,	0,	1,	1628843415,	1,	'News notice to mail'),
(12,	1626627540,	10080,	0,	'nv_newsnotice_auto_sendmail.php',	'cron_newsnotice_send_mail',	'newsnotice,vi_blog_rows',	0,	0,	1,	1628843415,	1,	'News notice to stack');

DROP TABLE IF EXISTS `qd_extension_files`;
CREATE TABLE `qd_extension_files` (
  `idfile` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  `title` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `path` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lastmodified` int(11) unsigned NOT NULL DEFAULT 0,
  `duplicate` smallint(4) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`idfile`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_extension_files`;
INSERT INTO `qd_extension_files` (`idfile`, `type`, `title`, `path`, `lastmodified`, `duplicate`) VALUES
(299,	'module',	'home',	'modules/home/funcs/.htaccess',	1596211130,	0),
(300,	'module',	'home',	'modules/home/funcs/index.html',	1596211130,	0),
(301,	'module',	'home',	'modules/home/funcs/main.php',	1596211130,	0),
(302,	'module',	'home',	'modules/home/functions.php',	1596211130,	0),
(303,	'module',	'home',	'modules/home/index.html',	1596211130,	0),
(304,	'module',	'home',	'modules/home/version.php',	1596211130,	0);

DROP TABLE IF EXISTS `qd_ips`;
CREATE TABLE `qd_ips` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `ip` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mask` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `area` tinyint(3) NOT NULL,
  `begintime` int(11) DEFAULT NULL,
  `endtime` int(11) DEFAULT NULL,
  `notice` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ip` (`ip`,`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_ips`;
INSERT INTO `qd_ips` (`id`, `type`, `ip`, `mask`, `area`, `begintime`, `endtime`, `notice`) VALUES
(1,	1,	'::1',	0,	1,	1596205106,	0,	'');

DROP TABLE IF EXISTS `qd_language`;
CREATE TABLE `qd_language` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `idfile` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `langtype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'lang_module',
  `lang_key` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `filelang` (`idfile`,`lang_key`,`langtype`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_language`;

DROP TABLE IF EXISTS `qd_language_file`;
CREATE TABLE `qd_language_file` (
  `idfile` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `admin_file` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0',
  `langtype` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'lang_module',
  PRIMARY KEY (`idfile`),
  UNIQUE KEY `module` (`module`,`admin_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_language_file`;

DROP TABLE IF EXISTS `qd_logs`;
CREATE TABLE `qd_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lang` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `note_action` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `link_acess` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `userid` mediumint(8) unsigned NOT NULL,
  `log_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_logs`;
INSERT INTO `qd_logs` (`id`, `lang`, `module_name`, `name_key`, `note_action`, `link_acess`, `userid`, `log_time`) VALUES
(1,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:::1',	'',	0,	1598170091),
(2,	'vi',	'modules',	'Xóa module \"news\"',	'',	'',	1,	1598170258),
(3,	'vi',	'modules',	'Xóa module \"contact\"',	'',	'',	1,	1598170263),
(4,	'vi',	'modules',	'Xóa module \"siteterms\"',	'',	'',	1,	1598170277),
(5,	'vi',	'modules',	'Xóa module \"freecontent\"',	'',	'',	1,	1598170279),
(6,	'vi',	'modules',	'Xóa module \"shops\"',	'',	'',	1,	1598170283),
(7,	'vi',	'modules',	'Thêm module ảo blog',	'',	'',	1,	1598170310),
(8,	'vi',	'modules',	'Thiết lập module mới blog',	'',	'',	1,	1598170322),
(9,	'vi',	'modules',	'Sửa module &ldquo;blog&rdquo;',	'',	'',	1,	1598170328),
(10,	'vi',	'modules',	'Thứ tự module: blog',	'13 -> 1',	'',	1,	1598170331),
(11,	'vi',	'modules',	'Xóa module \"home\"',	'',	'',	1,	1598170389),
(12,	'vi',	'modules',	'Xóa module \"about\"',	'',	'',	1,	1598170412),
(13,	'vi',	'themes',	'Thiết lập giao diện theme: \"huynhquocdat\"',	'',	'',	1,	1598170689),
(14,	'vi',	'themes',	'Kích hoạt theme: \"huynhquocdat\"',	'',	'',	1,	1598170692),
(15,	'vi',	'themes',	'Thiết lập layout theme: \"huynhquocdat\"',	'',	'',	1,	1598170984),
(16,	'vi',	'blog',	'Di chuyển bài viết',	'Thông cáo báo chí --> Sản phẩm',	'',	1,	1598174713),
(17,	'vi',	'blog',	'Di chuyển bài viết',	'Bản tin nội bộ --> Sản phẩm',	'',	1,	1598174719),
(18,	'vi',	'blog',	'Di chuyển bài viết',	'Tin công nghệ --> Tin tức',	'',	1,	1598174729),
(19,	'vi',	'modules',	'Thêm module ảo lien_he',	'',	'',	1,	1598175202),
(20,	'vi',	'modules',	'Thiết lập module mới lien-he',	'',	'',	1,	1598175208),
(21,	'vi',	'modules',	'Sửa module &ldquo;lien-he&rdquo;',	'',	'',	1,	1598175221),
(22,	'vi',	'menu',	'Delete menu item',	'Item ID 8',	'',	1,	1598175841),
(23,	'vi',	'menu',	'Delete menu item',	'Item ID 9',	'',	1,	1598175841),
(24,	'vi',	'menu',	'Delete menu item',	'Item ID 10',	'',	1,	1598175841),
(25,	'vi',	'menu',	'Delete menu item',	'Item ID 11',	'',	1,	1598175841),
(26,	'vi',	'menu',	'Delete menu item',	'Item ID 12',	'',	1,	1598175841),
(27,	'vi',	'menu',	'Delete menu item',	'Item ID 13',	'',	1,	1598175841),
(28,	'vi',	'menu',	'Delete menu item',	'Item ID 14',	'',	1,	1598175841),
(29,	'vi',	'menu',	'Delete menu item',	'Item ID 15',	'',	1,	1598175841),
(30,	'vi',	'menu',	'Delete menu item',	'Item ID 16',	'',	1,	1598175843),
(31,	'vi',	'menu',	'Delete menu item',	'Item ID 17',	'',	1,	1598175843),
(32,	'vi',	'menu',	'Delete menu item',	'Item ID 18',	'',	1,	1598175843),
(33,	'vi',	'menu',	'Delete menu item',	'Item ID 19',	'',	1,	1598175843),
(34,	'vi',	'menu',	'Delete menu item',	'Item ID 20',	'',	1,	1598175843),
(35,	'vi',	'menu',	'Delete menu item',	'Item ID 21',	'',	1,	1598175843),
(36,	'vi',	'menu',	'Delete menu item',	'Item ID 22',	'',	1,	1598175843),
(37,	'vi',	'blog',	'Thêm chuyên mục',	'Công nghệ',	'',	1,	1598179620),
(38,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1598180570),
(39,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1598180571),
(40,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1598180573),
(41,	'vi',	'blog',	'Xóa bài viêt',	'Hãy trở thành nhà cung cấp dịch vụ của NukeViet&#33;',	'',	1,	1598181988),
(42,	'vi',	'blog',	'Thêm chuyên mục',	'Gia đình',	'',	1,	1598184604),
(43,	'vi',	'themes',	'Thêm block',	'Name : TOP BLOG HOME SLIDER',	'',	1,	1598185749),
(44,	'vi',	'themes',	'Sửa block',	'Name : TOP BLOG HOME SLIDER',	'',	1,	1598185782),
(45,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1598186429),
(46,	'vi',	'themes',	'Thiết lập layout theme: \"huynhquocdat\"',	'',	'',	1,	1598186537),
(47,	'vi',	'themes',	'Thiết lập layout theme: \"huynhquocdat\"',	'',	'',	1,	1598186688),
(48,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1598187235),
(49,	'vi',	'login',	'[quocdatit] Thoát khỏi tài khoản Quản trị',	' Client IP:::1',	'',	1,	1598187237),
(50,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:::1',	'',	0,	1598247923),
(51,	'vi',	'database',	'Tải về',	'File name: nv_AD73.tmp',	'',	1,	1598247932),
(52,	'vi',	'login',	'[quocdatit] Thoát khỏi tài khoản Quản trị',	' Client IP:::1',	'',	0,	1598249729),
(53,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:::1',	'',	0,	1598446192),
(54,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.98.38.117',	'',	0,	1598446517),
(55,	'vi',	'blog',	'Xóa bài viêt',	'NukeViet 4.3 có gì mới?, NukeViet 4.2 có gì mới?, NukeViet 4.0 có gì mới?, Tuyển dụng lập trình viên PHP phát triển NukeViet, Hỗ trợ tập huấn và triển khai NukeViet cho các Phòng, Sở GD&amp;ĐT, NukeViet được Bộ GD&amp;ĐT đưa vào Hướng dẫn thực hiện nhiệm vụ CNTT năm học 2015 - 2016, Học việc tại công ty VINADES, Chương trình thực tập sinh tại công ty VINADES, Tuyển dụng lập trình viên front-end (HTML/CSS/JS) phát triển NukeViet, Tuyển dụng chuyên viên đồ hoạ phát triển NukeViet, Công ty VINADES tuyển dụng nhân viên kinh doanh, NukeViet được ưu tiên mua sắm, sử dụng trong cơ quan, tổ chức nhà nước, Mã nguồn mở NukeViet giành giải ba Nhân tài đất Việt 2011, Ra mắt công ty mã nguồn mở đầu tiên tại Việt Nam',	'',	1,	1598447780),
(56,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1598447807),
(57,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_08/thao-tung-tam-ly.jpg',	'',	1,	1598448140),
(58,	'vi',	'blog',	'Thêm bài viết',	'6 Hành vi thao túng tâm lý mà bạn không nên thỏa hiệp',	'',	1,	1598448259),
(59,	'vi',	'blog',	'Sửa bài viết',	'6 Hành vi thao túng tâm lý mà bạn không nên thỏa hiệp',	'',	1,	1598448334),
(60,	'vi',	'blog',	'Sửa bài viết',	'6 Hành vi thao túng tâm lý mà bạn không nên thỏa hiệp',	'',	1,	1598448436),
(61,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:117.2.158.199',	'',	0,	1598489741),
(62,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1598489762),
(63,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.98.38.117',	'',	0,	1598541663),
(64,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_08/barnum-feature.jpg',	'',	1,	1598541778),
(65,	'vi',	'blog',	'Thêm bài viết',	'Hiệu ứng Barnum – Bạn bị đánh lừa qua bài trắc nghiệm tâm lý?',	'',	1,	1598541925),
(66,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1598542003),
(67,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1598542126),
(68,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_08/han-gan-voi-ba-me-feature.jpg',	'',	1,	1598542278),
(69,	'vi',	'blog',	'Thêm bài viết',	'Làm sao để hàn gắn mối quan hệ với cha mẹ sau mâu thuẫn?',	'',	1,	1598542307),
(70,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.99.204.39',	'',	0,	1599217808),
(71,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.99.204.39',	'',	0,	1599318133),
(72,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/25-thuat-tam-ly-dinh-cao-lam-chu-moi-tinh-huong.jpg',	'',	1,	1599318229),
(73,	'vi',	'blog',	'Thêm bài viết',	'25 THUẬT TÂM LÝ ĐỈNH CAO LÀM CHỦ MỌI TÌNH HUỐNG',	'',	1,	1599318288),
(74,	'vi',	'blog',	'Thêm bài viết',	'Đổi mới công nghệ là yếu tố sống còn?',	'',	1,	1599318598),
(75,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/chau-a-doi-moi-cong-nghe-hay-la-chet.jpg',	'',	1,	1599318622),
(76,	'vi',	'blog',	'Sửa bài viết',	'Đổi mới công nghệ là yếu tố sống còn?',	'',	1,	1599318626),
(77,	'vi',	'upload',	'Xóa file',	'uploads/blog/2020_09/chau-a-doi-moi-cong-nghe-hay-la-chet.jpg',	'',	1,	1599318708),
(78,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/chau-a-doi-moi-cong-nghe-hay-la-chet.jpg',	'',	1,	1599318713),
(79,	'vi',	'blog',	'Sửa bài viết',	'Đổi mới công nghệ là yếu tố sống còn?',	'',	1,	1599318718),
(80,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/nghe-lap-trinh-va-nhung-su-that-it-nguoi-biet.jpg',	'',	1,	1599319228),
(81,	'vi',	'blog',	'Thêm bài viết',	'Nghề lập trình và những sự thật ít người biết',	'',	1,	1599319296),
(82,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/4-quy-tac-cua-ly-tieu-long-de-hinh-thanh-tinh-than-thep-huong-thien.jpg',	'',	1,	1599319527),
(83,	'vi',	'blog',	'Thêm bài viết',	'4 quy tắc của Lý Tiểu Long để hình thành tinh thần thép, hướng thiện',	'',	1,	1599319610),
(84,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.99.204.39',	'',	0,	1599398628),
(85,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.99.113.25',	'',	0,	1599488211),
(86,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.98.41.33',	'',	0,	1600578474),
(87,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/bi-quyet-de-moi-quan-he-dai-lau.jpg',	'',	1,	1600578578),
(88,	'vi',	'blog',	'Thêm bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1600578608),
(89,	'vi',	'blog',	'Sửa bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1600578706),
(90,	'vi',	'blog',	'Sửa bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1600578843),
(91,	'vi',	'blog',	'Sửa bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1600578934),
(92,	'vi',	'blog',	'Sửa bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1600578990),
(93,	'vi',	'blog',	'Sửa bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1600579014),
(94,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:117.7.120.126',	'',	0,	1600616326),
(95,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:117.7.120.126',	'',	0,	1600675847),
(96,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:117.7.120.126',	'',	0,	1600731459),
(97,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/google-http-2.jpg',	'',	1,	1600731539),
(98,	'vi',	'blog',	'Thêm bài viết',	'Googlebot sẽ sử dụng giao thức HTTP&#x002F;2 để thu thập thông tin thay cho HTTP&#x002F;1',	'',	1,	1600731591),
(99,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:117.7.120.126',	'',	0,	1600736079),
(100,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.98.84.237',	'',	0,	1602521001),
(101,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:116.98.37.148',	'',	0,	1606015843),
(102,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:113.189.108.42',	'',	0,	1609906331),
(103,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:123.19.27.156',	'',	0,	1611716001),
(104,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_01/1447_2021_1.jpg',	'',	1,	1611716261),
(105,	'vi',	'blog',	'Thêm bài viết',	'Biên tập cuộc đời - Chinh phục mục tiêu mới 2021',	'',	1,	1611716307),
(106,	'vi',	'blog',	'Sửa bài viết',	'Biên tập cuộc đời - Chinh phục mục tiêu mới 2021',	'',	1,	1611716341),
(107,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:123.19.27.156',	'',	0,	1611719921),
(108,	'vi',	'login',	'[quocdatit] Thoát khỏi tài khoản Quản trị',	' Client IP:123.19.27.156',	'',	0,	1611721726),
(109,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:171.227.161.100',	'',	0,	1617717312),
(110,	'vi',	'blog',	'Thêm bài viết',	'Phân biệt giữa Front End, Back End và Full Stack',	'',	1,	1617717416),
(111,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_04/fullstack.png',	'',	1,	1617717443),
(112,	'vi',	'blog',	'Sửa bài viết',	'Phân biệt giữa Front End, Back End và Full Stack',	'',	1,	1617717449),
(113,	'vi',	'blog',	'Sửa bài viết',	'Phân biệt giữa Front End, Back End và Full Stack',	'',	1,	1617717524),
(114,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:171.227.164.164',	'',	0,	1624415512),
(115,	'vi',	'database',	'Tải về',	'File name: nv_UacooP',	'',	1,	1624415527),
(116,	'vi',	'login',	'[quocdatit] Đăng nhập',	' Client IP:27.69.190.216',	'',	0,	1625648206),
(117,	'vi',	'users',	'Thay đổi cấu hình module',	'',	'',	1,	1625649945),
(118,	'vi',	'users',	'log_edit_user',	'userid 1',	'',	1,	1625649948),
(119,	'vi',	'blog',	'Thêm chuyên mục',	'Trải nghiệm',	'',	1,	1625650818),
(120,	'vi',	'blog',	'Di chuyển bài viết',	'Gia đình --> Cuộc sống',	'',	1,	1625650909),
(121,	'vi',	'blog',	'Di chuyển bài viết',	'Bản thân --> Trải nghiệm',	'',	1,	1625650918),
(122,	'vi',	'blog',	'Thêm chuyên mục',	'Tài chính',	'',	1,	1625650982),
(123,	'vi',	'blog',	'Thêm chuyên mục',	'Marketing',	'',	1,	1625650991),
(124,	'vi',	'blog',	'Thêm chuyên mục',	'Tản mạn',	'',	1,	1625651044),
(125,	'vi',	'blog',	'Thêm chuyên mục',	'Kinh doanh',	'',	1,	1625651058),
(126,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625651719),
(127,	'vi',	'blog',	'Xóa bài viêt',	'Phân biệt giữa Front End, Back End và Full Stack',	'',	1,	1625652388),
(128,	'vi',	'blog',	'Sửa bài viết',	'Biên tập cuộc đời - Chinh phục mục tiêu mới 2021',	'',	1,	1625652404),
(129,	'vi',	'blog',	'Thêm chuyên mục',	'NukeViet',	'',	1,	1625652589),
(130,	'vi',	'blog',	'Sửa bài viết',	'Bí quyết để mối quan hệ dài lâu?',	'',	1,	1625652879),
(131,	'vi',	'blog',	'Sửa bài viết',	'Hiệu ứng Barnum – Bạn bị đánh lừa qua bài trắc nghiệm tâm lý?',	'',	1,	1625652906),
(132,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625823021),
(133,	'vi',	'modules',	'Thiết lập module mới home',	'',	'',	1,	1625823045),
(134,	'vi',	'modules',	'Sửa module &ldquo;home&rdquo;',	'',	'',	1,	1625823051),
(135,	'vi',	'modules',	'Thứ tự module: home',	'13 -> 1',	'',	1,	1625823054),
(136,	'vi',	'upload',	'Upload file',	'uploads/56dc5c214637aa69f326.jpg',	'',	1,	1625823145),
(137,	'vi',	'upload',	'Đổi tên file',	'uploads/56dc5c214637aa69f326.jpg -> uploads/logo-huynhquocdat.jpg',	'',	1,	1625823161),
(138,	'vi',	'themes',	'Thiết lập layout theme: \"huynhquocdat\"',	'',	'',	1,	1625823359),
(139,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625825150),
(140,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625825552),
(141,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625825619),
(142,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625825728),
(143,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625825872),
(144,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1625825874),
(145,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625843001),
(146,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/danh-dum-tien-nhu-the-nao-de-duoc-nghi-huu-som.jpg',	'',	1,	1625843464),
(147,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210709221107-1.jpeg',	'',	1,	1625843495),
(148,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210709221107-2.jpeg',	'',	1,	1625843496),
(149,	'vi',	'blog',	'Thêm bài viết',	'Dành dụm tiền như thế nào để được “nghỉ hưu sớm”',	'',	1,	1625843678),
(150,	'vi',	'blog',	'Sửa bài viết',	'Dành dụm tiền như thế nào để được “nghỉ hưu sớm”',	'',	1,	1625843739),
(151,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_01/1447_2021_1.jpg',	'',	1,	1625844299),
(152,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_01/bien-tap-cuoc-doi-chinh-phuc-muc-tieu-moi-2021.jpg',	'',	1,	1625844303),
(153,	'vi',	'blog',	'Sửa bài viết',	'Biên tập cuộc đời - Chinh phục mục tiêu mới 2021',	'',	1,	1625844321),
(154,	'vi',	'blog',	'Xóa bài viêt',	'Bí quyết để mối quan hệ dài lâu?, 4 quy tắc của Lý Tiểu Long để hình thành tinh thần thép, hướng thiện',	'',	1,	1625844539),
(155,	'vi',	'upload',	'Xóa file',	'uploads/blog/2020_09/25-thuat-tam-ly-dinh-cao-lam-chu-moi-tinh-huong.jpg',	'',	1,	1625844867),
(156,	'vi',	'upload',	'Upload file',	'uploads/blog/2020_09/25-thuat-tam-ly.jpg',	'',	1,	1625844872),
(157,	'vi',	'blog',	'Sửa bài viết',	'25 thuật tâm lý đỉnh cao làm chủ mọi tình huống',	'',	1,	1625844902),
(158,	'vi',	'blog',	'Sửa bài viết',	'25 thuật tâm lý đỉnh cao làm chủ mọi tình huống',	'',	1,	1625844914),
(159,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625845044),
(160,	'vi',	'blog',	'Xóa bài viêt',	'Googlebot sẽ sử dụng giao thức HTTP&#x002F;2 để thu thập thông tin thay cho HTTP&#x002F;1, Nghề lập trình và những sự thật ít người biết, Đổi mới công nghệ là yếu tố sống còn?, Làm sao để hàn gắn mối quan hệ với cha mẹ sau mâu thuẫn?, Hiệu ứng Barnum – Bạn bị đánh lừa qua bài trắc nghiệm tâm lý?, 6 Hành vi thao túng tâm lý mà bạn không nên thỏa hiệp',	'',	1,	1625845264),
(161,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625846280),
(162,	'vi',	'blog',	'Sửa bài viết',	'Dành dụm tiền như thế nào để được “nghỉ hưu sớm”',	'',	1,	1625846378),
(163,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625847763),
(164,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1625848293),
(165,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625887133),
(166,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625887140),
(167,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625887917),
(168,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	0,	1625889735),
(169,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625928033),
(170,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625928039),
(171,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625932945),
(172,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/fix_module_shops_nukeviet.zip',	'',	1,	1625932976),
(173,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/huong-dan-sua-loi-cho-module-shop-nukeviet.jpg',	'',	1,	1625933481),
(174,	'vi',	'blog',	'Thêm bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1625933511),
(175,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1625933565),
(176,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1625934358),
(177,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1625934477),
(178,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625934480),
(179,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1625935785),
(180,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625936283),
(181,	'vi',	'blog',	'Thêm bài viết',	'Dịch vụ marketing online uy tín, hiệu quả tại Nha Trang',	'',	1,	1625936470),
(182,	'vi',	'blog',	'Sửa bài viết',	'Dịch vụ marketing online uy tín, hiệu quả tại Nha Trang',	'',	1,	1625936555),
(183,	'vi',	'blog',	'log_exp_content',	'listid: 34',	'',	1,	1625936593),
(184,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625936798),
(185,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1625936800),
(186,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625975224),
(187,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625992282),
(188,	'vi',	'comment',	'Xóa bình luận',	'listcid 5, 4, 3, 2, 1',	'',	1,	1625997520),
(189,	'vi',	'comment',	'Xóa bình luận',	'listcid 8, 7, 6',	'',	1,	1625997608),
(190,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625997669),
(191,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625998040),
(192,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625998107),
(193,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1625998149),
(194,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1625998165),
(195,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1625998263),
(196,	'vi',	'users',	'log_edit_user',	'userid 1',	'',	1,	1625998871),
(197,	'vi',	'comment',	'Xóa bình luận',	'listcid 11, 10, 9',	'',	1,	1625999134),
(198,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/10-nhom-khach-hang-thuong-gap.jpg',	'',	1,	1626000077),
(199,	'vi',	'blog',	'Thêm bài viết',	'10 nhóm khách hàng thường gặp và cách ứng xử',	'',	1,	1626000093),
(200,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626000240),
(201,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626000241),
(202,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626000243),
(203,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626000253),
(204,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626000663),
(205,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1626001064),
(206,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626022056),
(207,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/xu-huong-cong-nghe.jpg',	'',	1,	1626022350),
(208,	'vi',	'blog',	'Thêm bài viết',	'Những xu hướng công nghệ đáng chú ý trong năm 2021',	'',	1,	1626022372),
(209,	'vi',	'blog',	'Sửa bài viết',	'Những xu hướng công nghệ đáng chú ý trong năm 2021',	'',	1,	1626022479),
(210,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626024740),
(211,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626059191),
(212,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:125.234.228.239',	'',	0,	1626068389),
(213,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:125.234.228.239',	'',	1,	1626068606),
(214,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626102739),
(215,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626102754),
(216,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626102755),
(217,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626102757),
(218,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626102763),
(219,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	0,	1626105256),
(220,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626140316),
(221,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	0,	1626142154),
(222,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626144641),
(223,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210713095026-2.jpeg',	'',	1,	1626144654),
(224,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210713095026-1.jpeg',	'',	1,	1626144655),
(225,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210713095043-3.jpeg',	'',	1,	1626144671),
(226,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210713095043-4.png',	'',	1,	1626144671),
(227,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210713095101-6.png',	'',	1,	1626144689),
(228,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image-20210713095101-5.jpeg',	'',	1,	1626144690),
(229,	'vi',	'blog',	'Thêm bài viết',	'Lộ trình phát triển của một Software Engineer',	'',	1,	1626144938),
(230,	'vi',	'blog',	'Sửa bài viết',	'Lộ trình phát triển của một Software Engineer',	'',	1,	1626145081),
(231,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/lo-trinh-phat-trien-software-engineer.jpg',	'',	1,	1626145425),
(232,	'vi',	'blog',	'Sửa bài viết',	'Lộ trình phát triển của một Software Engineer',	'',	1,	1626145430),
(233,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626145475),
(234,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626145476),
(235,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626145479),
(236,	'vi',	'upload',	'Tạo lại ảnh thumb',	'uploads/blog',	'',	1,	1626145481),
(237,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626145495),
(238,	'vi',	'users',	'log_edit_user',	'userid 1',	'',	1,	1626146082),
(239,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626174281),
(240,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/tips-meo-danh-cho-lap-trinh-vien-nukeviet-cms.jpg',	'',	1,	1626174388),
(241,	'vi',	'blog',	'Thêm bài viết',	'Một số Tips hay dành cho lập trình viên NukeViet CMS',	'',	1,	1626174699),
(242,	'vi',	'blog',	'Sửa bài viết',	'Một số Tips hay dành cho lập trình viên NukeViet CMS',	'',	1,	1626174745),
(243,	'vi',	'blog',	'Sửa bài viết',	'Một số Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626174796),
(244,	'vi',	'blog',	'Sửa bài viết',	'Một số Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626180009),
(245,	'vi',	'blog',	'Sửa bài viết',	'Một số Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626180116),
(246,	'vi',	'blog',	'Sửa bài viết',	'Một số Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626180160),
(247,	'vi',	'blog',	'Sửa bài viết',	'Một số Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626180454),
(248,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626181969),
(249,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1626185119),
(250,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626185134),
(251,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626185141),
(252,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	1,	1626185142),
(253,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626249125),
(254,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626251768),
(255,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626253134),
(256,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626253809),
(257,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626253922),
(258,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626253968),
(259,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626254068),
(260,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626254218),
(261,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626254442),
(262,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626254598),
(263,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626254614),
(264,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	0,	1626256457),
(265,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626266703),
(266,	'vi',	'blog',	'Thêm bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626267022),
(267,	'vi',	'blog',	'log_exp_content',	'listid: 39',	'',	1,	1626267030),
(268,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626267141),
(269,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cong-ty-thiet-ke-website-tai-nha-trang-khanh-hoa.jpg',	'',	1,	1626267820),
(270,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626267829),
(271,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626267966),
(272,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_07/cong-ty-thiet-ke-website-tai-nha-trang-khanh-hoa.jpg',	'',	1,	1626268852),
(273,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cong-ty-thiet-ke-website-tai-nha-trang-khanh-hoa.jpg',	'',	1,	1626268857),
(274,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626268863),
(275,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/dich-vu-marketing-online-nha-trang-khanh-hoa.jpg',	'',	1,	1626270417),
(276,	'vi',	'blog',	'Sửa bài viết',	'Dịch vụ marketing online uy tín, hiệu quả tại Nha Trang',	'',	1,	1626270599),
(277,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626317569),
(278,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626319765),
(279,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1626319801),
(280,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626320941),
(281,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626338566),
(282,	'vi',	'extensions',	'Cài đặt ứng dụng',	'nv4_module_newsnotice.zip',	'',	1,	1626338829),
(283,	'vi',	'modules',	'Thiết lập module mới newsnotice',	'',	'',	1,	1626338840),
(284,	'vi',	'modules',	'Sửa module &ldquo;newsnotice&rdquo;',	'',	'',	1,	1626338848),
(285,	'vi',	'modules',	'Thứ tự module: newsnotice',	'14 -> 4',	'',	1,	1626338854),
(286,	'vi',	'themes',	'Sửa block',	'Name : Copyright',	'',	1,	1626339933),
(287,	'vi',	'modules',	'Xóa module \"newsnotice\"',	'',	'',	1,	1626340779),
(288,	'vi',	'extensions',	'Cài đặt ứng dụng',	'module-newsnotice-develop.zip',	'',	1,	1626340807),
(289,	'vi',	'modules',	'Thiết lập module mới newsnotice',	'',	'',	1,	1626340879),
(290,	'vi',	'modules',	'Sửa module &ldquo;newsnotice&rdquo;',	'',	'',	1,	1626340885),
(291,	'vi',	'modules',	'Thứ tự module: newsnotice',	'14 -> 3',	'',	1,	1626340889),
(292,	'vi',	'themes',	'Thêm block',	'Name : Đăng ký nhận tin từ Email',	'',	1,	1626341081),
(293,	'vi',	'settings',	'log_cronjob_edit',	'id 13',	'',	1,	1626341204),
(294,	'vi',	'settings',	'log_cronjob_edit',	'id 12',	'',	1,	1626341225),
(295,	'vi',	'settings',	'log_cronjob_atc',	'id 6',	'',	1,	1626341436),
(296,	'vi',	'settings',	'log_cronjob_edit',	'id 12',	'',	1,	1626341475),
(297,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626343676),
(298,	'vi',	'blog',	'Thêm bài viết',	'test bài viết',	'',	1,	1626346377),
(299,	'vi',	'settings',	'log_cronjob_edit',	'id 12',	'',	1,	1626346708),
(300,	'vi',	'settings',	'log_cronjob_edit',	'id 12',	'',	1,	1626346722),
(301,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626346727),
(302,	'vi',	'blog',	'Xóa bài viêt',	'test bài viết',	'',	1,	1626346856),
(303,	'vi',	'settings',	'log_cronjob_edit',	'id 12',	'',	1,	1626346899),
(304,	'vi',	'settings',	'log_cronjob_edit',	'id 13',	'',	1,	1626346916),
(305,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626363906),
(306,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/60-cach-cai-thien-ban-than-trong-100-ngay.jpg',	'',	1,	1626364508),
(307,	'vi',	'blog',	'Thêm bài viết',	'60 cách đơn giản giúp cải thiện bản thân trong vòng 100 ngày',	'',	1,	1626364557),
(308,	'vi',	'blog',	'Sửa bài viết',	'60 cách đơn giản giúp cải thiện bản thân trong vòng 100 ngày',	'',	1,	1626364624),
(309,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626398486),
(310,	'vi',	'settings',	'log_cronjob_edit',	'id 13',	'',	1,	1626399089),
(311,	'vi',	'settings',	'log_cronjob_edit',	'id 12',	'',	1,	1626399147),
(312,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626530254),
(313,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626530977),
(314,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1626531515),
(315,	'vi',	'blog',	'Sửa bài viết',	'Dịch vụ marketing online uy tín, hiệu quả tại Nha Trang',	'',	1,	1626531610),
(316,	'vi',	'blog',	'Sửa bài viết',	'Digital Marketing Nha Trang',	'',	1,	1626532169),
(317,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng Hợp&#93; Kiến Thức Digital Marketing Nha Trang',	'',	1,	1626532326),
(318,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng Hợp&#93; Kiến Thức Digital Marketing Nha Trang',	'',	1,	1626532338),
(319,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng Hợp&#93; Kiến Thức Digital Marketing Nha Trang',	'',	1,	1626532354),
(320,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng Hợp&#93; Kiến Thức Digital Marketing Nha Trang',	'',	1,	1626532974),
(321,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626533569),
(322,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626576107),
(323,	'vi',	'comment',	'Sửa bình luận: blog, id: 38, cid: 20',	'@Huỳnh Quốc Đạt thử luôn nó đây này &#x3A;D https&#x3A;&#x002F;&#x002F;demo.kttvhcm.com&#x002F;',	'',	1,	1626576163),
(324,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626576294),
(325,	'vi',	'upload',	'Upload file',	'uploads/blog/nukeviet-cms.jpg',	'',	1,	1626577212),
(326,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626579362),
(327,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng Hợp&#93; Kiến Thức Digital Marketing Nha Trang',	'',	1,	1626579917),
(328,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626617115),
(329,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	0,	1626620551),
(330,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626621713),
(331,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626658335),
(332,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626658341),
(333,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626692803),
(334,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626744627),
(335,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/nukeviet-4-5-co-gi-moi.jpg',	'',	1,	1626745346),
(336,	'vi',	'blog',	'Thêm bài viết',	'NukeViet 4.5 có gì mới?',	'',	1,	1626745400),
(337,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626745736),
(338,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626749248),
(339,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/tieu-chuan-bao-mat-owasp.jpg',	'',	1,	1626749269),
(340,	'vi',	'blog',	'Thêm bài viết',	'Tiêu chuẩn bảo mật OWASP',	'',	1,	1626749432),
(341,	'vi',	'blog',	'Sửa bài viết',	'Tiêu chuẩn bảo mật OWASP',	'',	1,	1626749551),
(342,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1626749902),
(343,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1626841314),
(344,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1627008701),
(345,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1627094933),
(346,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/thuc-tap-lap-trinh-som.jpg',	'',	1,	1627096932),
(347,	'vi',	'blog',	'Thêm bài viết',	'Làm sao để sinh viên CNTT thực tập lập trình sớm?',	'',	1,	1627096996),
(348,	'vi',	'blog',	'Sửa bài viết',	'Làm sao để sinh viên CNTT thực tập lập trình sớm?',	'',	1,	1627097048),
(349,	'vi',	'blog',	'Sửa bài viết',	'Làm sao để sinh viên CNTT thực tập lập trình sớm?',	'',	1,	1627097111),
(350,	'vi',	'blog',	'Sửa bài viết',	'Làm sao để sinh viên CNTT thực tập lập trình sớm?',	'',	1,	1627097241),
(351,	'vi',	'blog',	'Sửa bài viết',	'Làm sao để sinh viên CNTT thực tập lập trình sớm?',	'',	1,	1627097345),
(352,	'vi',	'blog',	'Sửa bài viết',	'Làm sao để sinh viên CNTT thực tập lập trình sớm?',	'',	1,	1627097437),
(353,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.252.170.201',	'',	0,	1627101196),
(354,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.252.170.201',	'',	0,	1627103618),
(355,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.255.151.187',	'',	0,	1627371601),
(356,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/xay-dung-chan-dung-khach-hang.jpg',	'',	1,	1627371778),
(357,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/buyer-persona.png',	'',	1,	1627372311),
(358,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image.png',	'',	1,	1627372765),
(359,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image_1.png',	'',	1,	1627372816),
(360,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/image_2.png',	'',	1,	1627372937),
(361,	'vi',	'blog',	'Thêm bài viết',	'Vẽ Chân Dung Khách Hàng Mục Tiêu',	'',	1,	1627372990),
(362,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/customer-persona-template-abc-digi.xlsx',	'',	1,	1627373262),
(363,	'vi',	'blog',	'Sửa bài viết',	'Vẽ Chân Dung Khách Hàng Mục Tiêu',	'',	1,	1627373355),
(364,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.255.151.187',	'',	0,	1627394923),
(365,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.255.153.166',	'',	0,	1627483668),
(366,	'vi',	'database',	'Tải về',	'File name: nv_XDcQoU',	'',	1,	1627483676),
(367,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.255.153.166',	'',	0,	1627487883),
(368,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.255.153.166',	'',	0,	1627489917),
(369,	'vi',	'extensions',	'Cài đặt ứng dụng',	'litespeed-cache-v1-0-01.zip',	'',	1,	1627489933),
(370,	'vi',	'modules',	'Thiết lập module mới litespeedcache',	'',	'',	1,	1627489938),
(371,	'vi',	'modules',	'Sửa module &ldquo;litespeedcache&rdquo;',	'',	'',	1,	1627489940),
(372,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1627490427),
(373,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:27.68.159.30',	'',	0,	1627548809),
(374,	'vi',	'blog',	'edit_tags',	'dao-tao-digital-marketing-nha-trang',	'',	1,	1627549712),
(375,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:27.66.53.12',	'',	0,	1627637177),
(376,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638033),
(377,	'vi',	'blog',	'Thêm bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1627638043),
(378,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638183),
(379,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638189),
(380,	'vi',	'blog',	'Sửa bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1627638193),
(381,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638646),
(382,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638651),
(383,	'vi',	'blog',	'Sửa bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1627638655),
(384,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638908),
(385,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627638916),
(386,	'vi',	'blog',	'Sửa bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1627638921),
(387,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627639011),
(388,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	'',	1,	1627639016),
(389,	'vi',	'blog',	'Sửa bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1627639021),
(390,	'vi',	'blog',	'Sửa bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1627639588),
(391,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1627639947),
(392,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1627640167),
(393,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1627641277),
(394,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:27.66.51.236',	'',	0,	1627807178),
(395,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801153947-1.png',	'',	1,	1627807191),
(396,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801154225-2.png',	'',	1,	1627807348),
(397,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801154225-4.png',	'',	1,	1627807349),
(398,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801154225-5.png',	'',	1,	1627807349),
(399,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801154225-7.png',	'',	1,	1627807349),
(400,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801154225-6.png',	'',	1,	1627807349),
(401,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/image-20210801154225-3.png',	'',	1,	1627807349),
(402,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/huong-dan-tuy-bien-module-lien-he-nukeviet-cms.jpg',	'',	1,	1627807775),
(403,	'vi',	'blog',	'Thêm bài viết',	'&#91;NV4&#93; Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1627808037),
(404,	'vi',	'blog',	'Sửa bài viết',	'&#91;NV4&#93; Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1627808069),
(405,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:27.66.51.236',	'',	1,	1627810546),
(406,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:27.66.51.236',	'',	0,	1627812496),
(407,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1627812505),
(408,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_08/huong-dan-tuy-bien-module-lien-he-nukeviet-cms.jpg',	'',	1,	1627812536),
(409,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/huong-dan-tuy-bien-module-lien-he-nukeviet-cms.jpg',	'',	1,	1627812541),
(410,	'vi',	'blog',	'Sửa bài viết',	'&#91;NV4&#93; Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1627812545),
(411,	'vi',	'upload',	'Đổi tên file',	'uploads/blog/2021_08/huong-dan-tuy-bien-module-lien-he-nukeviet-cms.jpg -> uploads/blog/2021_08/huong-dan-tuy-bien-module-lien-he-nukeviet-cms-2.jpg',	'',	1,	1627812575),
(412,	'vi',	'blog',	'Sửa bài viết',	'&#91;NV4&#93; Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1627812579),
(413,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.254.153.123',	'',	0,	1627834227),
(414,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.254.153.123',	'',	1,	1627834332),
(415,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.254.153.123',	'',	0,	1627834613),
(416,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1627834625),
(417,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.254.153.123',	'',	1,	1627834638),
(418,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.255.136.134',	'',	0,	1627920044),
(419,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:27.69.160.254',	'',	0,	1628094402),
(420,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628259711),
(421,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628299033),
(422,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/seo-01.png',	'',	1,	1628300034),
(423,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1628300252),
(424,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1628301002),
(425,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1628301542),
(426,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1628303364),
(427,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628303440),
(428,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628303569),
(429,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628345504),
(430,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	0,	1628347322),
(431,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628391034),
(432,	'vi',	'blog',	'edit_tags',	'back-end',	'',	1,	1628391173),
(433,	'vi',	'blog',	'edit_tags',	'back-end',	'',	1,	1628391197),
(434,	'vi',	'blog',	'edit_tags',	'cong-ty-thiet-ke-web-nha-trang',	'',	1,	1628391229),
(435,	'vi',	'blog',	'edit_tags',	'chia-se-module-nukeviet',	'',	1,	1628391244),
(436,	'vi',	'blog',	'edit_tags',	'cau-truc-du-lieu',	'',	1,	1628391250),
(437,	'vi',	'blog',	'edit_tags',	'cong-nghe-thong-tin',	'',	1,	1628391255),
(438,	'vi',	'blog',	'edit_tags',	'cong-ty-dich-vu-marketing-online',	'',	1,	1628391270),
(439,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628391290),
(440,	'vi',	'blog',	'edit_tags',	'dich-vu-digital-marketing-nha-trang',	'',	1,	1628393879),
(441,	'vi',	'blog',	'edit_tags',	'digital-marketing-nha-trang',	'',	1,	1628393891),
(442,	'vi',	'blog',	'edit_tags',	'kinh-nghiem-digital-marketing-nha-trang',	'',	1,	1628393902),
(443,	'vi',	'blog',	'edit_tags',	'dao-tao-digital-marketing-nha-trang',	'',	1,	1628393997),
(444,	'vi',	'blog',	'edit_tags',	'dich-vu-digital-marketing-nha-trang',	'',	1,	1628394006),
(445,	'vi',	'blog',	'edit_tags',	'digital-marketing-nha-trang',	'',	1,	1628394013),
(446,	'vi',	'blog',	'edit_tags',	'kinh-nghiem-digital-marketing-nha-trang',	'',	1,	1628394021),
(447,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628585318),
(448,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	0,	1628587137),
(449,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628591756),
(450,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/hoc-thuat-toan-the-nao-cho-hieu-qua.jpg',	'',	1,	1628591769),
(451,	'vi',	'blog',	'Thêm bài viết',	'Học Thuật Toán Thế Nào Cho Hiệu Quả?',	'',	1,	1628591776),
(452,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628648880),
(453,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1628648965),
(454,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628649494),
(455,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628649505),
(456,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628664373),
(457,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/cac-kho-khan-ban-co-the-gap-khi-hoc-cong-nghe-thong-tin.jpg',	'',	1,	1628664870),
(458,	'vi',	'blog',	'Thêm bài viết',	'6 khó khăn có thể bạn sẽ gặp khi theo học ngành CNTT',	'',	1,	1628665033),
(459,	'vi',	'blog',	'Sửa bài viết',	'6 khó khăn có thể bạn sẽ gặp khi theo học ngành CNTT',	'',	1,	1628665067),
(460,	'vi',	'blog',	'Sửa bài viết',	'6 khó khăn có thể bạn sẽ gặp khi theo học ngành CNTT',	'',	1,	1628665689),
(461,	'vi',	'blog',	'Sửa bài viết',	'6 khó khăn có thể bạn sẽ gặp khi theo học ngành CNTT',	'',	1,	1628665705),
(462,	'vi',	'blog',	'Sửa bài viết',	'Học Thuật Toán Thế Nào Cho Hiệu Quả?',	'',	1,	1628667856),
(463,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628667947),
(464,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628669574),
(465,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628669732),
(466,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628669735),
(467,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628673555),
(468,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628673561),
(469,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628673819),
(470,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628674193),
(471,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628675336),
(472,	'vi',	'upload',	'Upload file',	'uploads/favicon.ico',	'',	1,	1628675356),
(473,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628675585),
(474,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628676617),
(475,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628676620),
(476,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628679050),
(477,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628681018),
(478,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628681021),
(479,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628685941),
(480,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628685959),
(481,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628686180),
(482,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/thiet-ke-website-nha-trang-khanh-hoa.png',	'',	1,	1628686209),
(483,	'vi',	'upload',	'Xóa file',	'uploads/blog/2021_07/thiet-ke-website-nha-trang-khanh-hoa.png',	'',	1,	1628686215),
(484,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/cong-ty-thiet-ke-website-chuan-seo-tai-nha-trang-khanh-hoa.jpg',	'',	1,	1628686366),
(485,	'vi',	'blog',	'Sửa bài viết',	'&#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa',	'',	1,	1628686375),
(486,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	0,	1628688969),
(487,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628751467),
(488,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/nhung-thu-minh-co-la-gia-tri.jpg',	'',	1,	1628751569),
(489,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/can-bang-cuoc-song.jpg',	'',	1,	1628751682),
(490,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/tu-duy-nguoc.jpg',	'',	1,	1628751795),
(491,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/7-cach-de-song-tich-cuc-hon.jpg',	'',	1,	1628753080),
(492,	'vi',	'blog',	'Thêm bài viết',	'7 cách để sống tích cực hơn',	'',	1,	1628753086),
(493,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628753351),
(494,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628754053),
(495,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628754365),
(496,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628754367),
(497,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628755140),
(498,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/nukeviet-cms-la-gi.jpg',	'',	1,	1628756184),
(499,	'vi',	'blog',	'Thêm bài viết',	'NukeViet CMS là gì?',	'',	1,	1628756200),
(500,	'vi',	'blog',	'Sửa bài viết',	'NukeViet CMS là gì?',	'',	1,	1628756463),
(501,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628758871),
(502,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628758873),
(503,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628760161),
(504,	'vi',	'blog',	'Sửa bài viết',	'NukeViet CMS là gì?',	'',	1,	1628760479),
(505,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628760713),
(506,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628760715),
(507,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628786414),
(508,	'vi',	'extensions',	'Cài đặt ứng dụng',	'nv4_module_autoget-news.zip',	'',	1,	1628786599),
(509,	'vi',	'modules',	'Thiết lập module mới autoget-news',	'',	'',	1,	1628786607),
(510,	'vi',	'modules',	'Sửa module &ldquo;autoget-news&rdquo;',	'',	'',	1,	1628786614),
(511,	'vi',	'modules',	'Thứ tự module: autoget-news',	'16 -> 3',	'',	1,	1628786622),
(512,	'vi',	'autoget-news',	'Cấu hình',	'Config',	'',	1,	1628786869),
(513,	'vi',	'blog',	'Xóa bài viêt',	'Thông báo phát hành NukeViet 4.3.07, Thông báo phát hành NukeViet 4.3.08, Thông báo phát hành NukeViet 4.4.00, Thông báo phát hành NukeViet 4.4.01',	'',	1,	1628786983),
(514,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/thong-bao-phat-hanh-nukeviet-4.5.00.jpg',	'',	1,	1628787340),
(515,	'vi',	'blog',	'Sửa bài viết',	'Thông báo phát hành NukeViet 4.5.00',	'',	1,	1628787351),
(516,	'vi',	'blog',	'Sửa bài viết',	'NukeViet 4.5 có gì mới?',	'',	1,	1628787895),
(517,	'vi',	'blog',	'Sửa bài viết',	'Thông báo phát hành NukeViet 4.5.00',	'',	1,	1628787970),
(518,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628789976),
(519,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628789978),
(520,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628820468),
(521,	'vi',	'blog',	'Sửa bài viết',	'&#91;NV4&#93; Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1628820483),
(522,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1628820521),
(523,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1628820584),
(524,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1628820598),
(525,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628826973),
(526,	'vi',	'blog',	'edit_tags',	'dao-tao-digital-marketing-nha-trang',	'',	1,	1628828327),
(527,	'vi',	'blog',	'edit_tags',	'dao-tao-digital-marketing-nha-trang',	'',	1,	1628828353),
(528,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628836903),
(529,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628837468),
(530,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628837475),
(531,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628837555),
(532,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628839839),
(533,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628872393),
(534,	'vi',	'blog',	'edit_tags',	'themes-nukeviet',	'',	1,	1628873254),
(535,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-2.jpg',	'',	1,	1628874911),
(536,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-3.jpg',	'',	1,	1628874960),
(537,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-5.jpg',	'',	1,	1628875005),
(538,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-4.jpg',	'',	1,	1628875073),
(539,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-chua-biet-nhung-dieu-nay-thi-dung-mo-khoi-nghiep-nhe.jpg',	'',	1,	1628875846),
(540,	'vi',	'blog',	'Thêm bài viết',	'Bắt đầu khởi nghiệp kiểu gì?',	'',	1,	1628875855),
(541,	'vi',	'blog',	'Xóa bài viêt',	'Thông báo phát hành NukeViet 4.3.06',	'',	1,	1628875870),
(542,	'vi',	'blog',	'Sửa bài viết',	'Bắt đầu khởi nghiệp kiểu gì?',	'',	1,	1628876327),
(543,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628877003),
(544,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628877006),
(545,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628877036),
(546,	'vi',	'blog',	'Sửa bài viết',	'Dành dụm tiền như thế nào để được “nghỉ hưu sớm”',	'',	1,	1628877123),
(547,	'vi',	'blog',	'Sửa bài viết',	'10 nhóm khách hàng thường gặp và cách ứng xử',	'',	1,	1628877179),
(548,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628877184),
(549,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628877186),
(550,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628907504),
(551,	'vi',	'blog',	'Sửa bài viết',	'NukeViet CMS là gì?',	'',	1,	1628907521),
(552,	'vi',	'blog',	'Sửa bài viết',	'Vẽ Chân Dung Khách Hàng Mục Tiêu',	'',	1,	1628908876),
(553,	'vi',	'blog',	'Sửa bài viết',	'6 khó khăn có thể bạn sẽ gặp khi theo học ngành CNTT',	'',	1,	1628910433),
(554,	'vi',	'blog',	'Sửa bài viết',	'Học Thuật Toán Thế Nào Cho Hiệu Quả?',	'',	1,	1628910450),
(555,	'vi',	'blog',	'Sửa bài viết',	'Cấu trúc dữ liệu và giải thuật',	'',	1,	1628910487),
(556,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1628910535),
(557,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1628910541),
(558,	'vi',	'blog',	'Sửa bài viết',	'&#91;NV4&#93; Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1628910570),
(559,	'vi',	'upload',	'Upload file',	'uploads/blog/topics/nukeviet-cms-la-gi.jpg',	'',	1,	1628912667),
(560,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1628912671),
(561,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/huong-dan-tuy-bien-module-lien-he.jpg',	'',	1,	1628913787),
(562,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn tùy biến Module Liên hệ',	'',	1,	1628913794),
(563,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/tips-meo-danh-cho-lap-trinh-vien-nukeviet-cms_1.jpg',	'',	1,	1628913975),
(564,	'vi',	'blog',	'Sửa bài viết',	'&#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS',	'',	1,	1628913979),
(565,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/nukeviet-4-5-co-gi-moi_1.jpg',	'',	1,	1628914257),
(566,	'vi',	'blog',	'Sửa bài viết',	'NukeViet 4.5 có gì mới?',	'',	1,	1628914263),
(567,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_07/huong-dan-sua-loi-cho-module-shop-nukeviet_1.jpg',	'',	1,	1628914396),
(568,	'vi',	'blog',	'Sửa bài viết',	'Hướng dẫn sửa các lỗi cho module Shop - NukeViet',	'',	1,	1628914418),
(569,	'vi',	'upload',	'Upload file',	'uploads/blog/nukeviet-cms-la-gi.jpg',	'',	1,	1628914458),
(570,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628916541),
(571,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628946640),
(572,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628956368),
(573,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628956395),
(574,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1628966598),
(575,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/6-thoi-quen-xau-anh-huong-den-su-nghiep-cua-ban.jpg',	'',	1,	1628967316),
(576,	'vi',	'blog',	'Thêm bài viết',	'6 thói quen xấu ảnh hưởng đến sự nghiệp của bạn',	'',	1,	1628967323),
(577,	'vi',	'blog',	'Xóa bài viêt',	'Thông báo phát hành NukeViet 4.3.05',	'',	1,	1628967328),
(578,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1628967662),
(579,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	1,	1628967686),
(580,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1629035710),
(581,	'vi',	'blog',	'log_add_topic',	' ',	'',	1,	1629036391),
(582,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	0,	1629038230),
(583,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1629038511),
(584,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	0,	1629040690),
(585,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1629045987),
(586,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1629079163),
(587,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1629082948),
(588,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1629083135),
(589,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1629083147),
(590,	'vi',	'blog',	'log_add_topic',	' ',	'',	1,	1629083160),
(591,	'vi',	'blog',	'log_del_topic',	'topicid 3',	'',	1,	1629083164),
(592,	'vi',	'blog',	'log_del_topic',	'topicid 2',	'',	1,	1629083212),
(593,	'vi',	'blog',	'log_add_topic',	' ',	'',	1,	1629083228),
(594,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1629083251),
(595,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1629083855),
(596,	'vi',	'blog',	'log_edit_topic',	'topicid 1',	'',	1,	1629083875),
(597,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.227.171.33',	'',	0,	1629169332),
(598,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.227.171.33',	'',	0,	1629171137),
(599,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.245.233.118',	'',	0,	1629261945),
(600,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/untitled-design-34.png',	'',	1,	1629262187),
(601,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/list-sach-hay-ve-tam-nhin-cover-780x470.png',	'',	1,	1629262363),
(602,	'vi',	'upload',	'Upload file',	'uploads/blog/2021_08/7-loai-cong-ty-se-khong-bao-gio-kha-len-duoc.jpg',	'',	1,	1629262788),
(603,	'vi',	'blog',	'Thêm bài viết',	'7 loại công ty sẽ không bao giờ khá lên được',	'',	1,	1629262887),
(604,	'vi',	'login',	'[dat] Thoát khỏi tài khoản Quản trị',	' Client IP:171.245.233.118',	'',	1,	1629263807),
(605,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:171.245.229.129',	'',	0,	1629361996),
(606,	'vi',	'database',	'Tải về',	'File name: nv_jdWeZl',	'',	1,	1629362655),
(607,	'vi',	'login',	'[dat] Đăng nhập',	' Client IP:127.0.0.1',	'',	0,	1629363956),
(608,	'vi',	'webtools',	'Dọn dẹp hệ thống',	'clearcache, clearfiletemp, clearerrorlogs, clearip_logs',	'',	1,	1629364004),
(609,	'vi',	'modules',	'Xóa module \"autoget-news\"',	'',	'',	1,	1629364016),
(610,	'vi',	'modules',	'Xóa module \"litespeedcache\"',	'',	'',	1,	1629364022),
(611,	'vi',	'modules',	'Xóa module \"lien-he\"',	'',	'',	1,	1629364025),
(612,	'vi',	'statistics',	'Clear statistics',	'All',	'',	1,	1629364042),
(613,	'vi',	'blog',	'Xóa bài viêt',	'Thông báo phát hành NukeViet 4.3.04, Hướng dẫn Fix lỗi bảo mật của NukeViet 4.x, Thông báo phát hành NukeViet 4.3.03, Thông báo phát hành NukeViet 4.3.02',	'',	1,	1629364102),
(614,	'vi',	'comment',	'Xóa bình luận',	'listcid 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14',	'',	1,	1629364169),
(615,	'vi',	'comment',	'Xóa bình luận',	'listcid 13, 12',	'',	1,	1629364174),
(616,	'vi',	'extensions',	'log_del_theme',	'theme mobile_default',	'',	1,	1629364276),
(617,	'vi',	'blog',	'Thêm chuyên mục',	'Sản phẩm',	'',	1,	1629364480),
(618,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Sản phẩm',	'',	1,	1629364518),
(619,	'vi',	'blog',	'Thêm chuyên mục',	'Liên hệ',	'',	1,	1629364522),
(620,	'vi',	'blog',	'log_del_topic',	'topicid 1',	'',	1,	1629364534),
(621,	'vi',	'blog',	'log_del_topic',	'topicid 1',	'',	1,	1629364535),
(622,	'vi',	'blog',	'log_del_topic',	'topicid 4',	'',	1,	1629364536),
(623,	'vi',	'blog',	'Xóa bài viêt',	'7 loại công ty sẽ không bao giờ khá lên được, 6 thói quen xấu ảnh hưởng đến sự nghiệp của bạn, Bắt đầu khởi nghiệp kiểu gì?, NukeViet CMS là gì?, 7 cách để sống tích cực hơn, 6 khó khăn có thể bạn sẽ gặp khi theo học ngành CNTT, Học Thuật Toán Thế Nào Cho Hiệu Quả?, Hướng dẫn tùy biến Module Liên hệ, Cấu trúc dữ liệu và giải thuật, Vẽ Chân Dung Khách Hàng Mục Tiêu, Làm sao để sinh viên CNTT thực tập lập trình sớm?, Tiêu chuẩn bảo mật OWASP, NukeViet 4.5 có gì mới?, 60 cách đơn giản giúp cải thiện bản thân trong vòng 100 ngày, &#91;TOP 10&#93; Công ty Thiết kế website Chuẩn SEO tại Nha Trang, Khánh Hòa, &#91;Tổng hợp&#93; Tips hay dành cho các lập trình viên NukeViet CMS, Lộ trình phát triển của một Software Engineer, Những xu hướng công nghệ đáng chú ý trong năm 2021, 10 nhóm khách hàng thường gặp và cách ứng xử, &#91;Tổng Hợp&#93; Kiến Thức Digital Marketing Nha Trang, Hướng dẫn sửa các lỗi cho module Shop - NukeViet, Dành dụm tiền như thế nào để được “nghỉ hưu sớm”, Biên tập cuộc đời - Chinh phục mục tiêu mới 2021, 25 thuật tâm lý đỉnh cao làm chủ mọi tình huống, Thông báo phát hành NukeViet 4.5.00',	'',	1,	1629364557),
(624,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Cuộc sống',	'',	1,	1629364562),
(625,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'NukeViet',	'',	1,	1629364563),
(626,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Development',	'',	1,	1629364564),
(627,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Công nghệ',	'',	1,	1629364565),
(628,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Trải nghiệm',	'',	1,	1629364566),
(629,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Sách hay',	'',	1,	1629364567),
(630,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Tài chính',	'',	1,	1629364568),
(631,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Marketing',	'',	1,	1629364568),
(632,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Tản mạn',	'',	1,	1629364569),
(633,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Kinh doanh',	'',	1,	1629364570),
(634,	'vi',	'blog',	'Xóa Chuyên mục và các bài viết',	'Liên hệ',	'',	1,	1629364571),
(635,	'vi',	'blog',	'Thêm chuyên mục',	'Chuyên mục đầu tiền',	'',	1,	1629364582),
(636,	'vi',	'blog',	'Thêm bài viết',	'Bài viết đầu tiên',	'',	1,	1629364697),
(637,	'vi',	'blog',	'Sửa bài viết',	'Bài viết đầu tiên',	'',	1,	1629364803),
(638,	'vi',	'users',	'log_edit_user',	'userid 1',	'',	1,	1629365492),
(639,	'vi',	'themes',	'Sửa block',	'Name : Đăng nhập thành viên',	'',	1,	1629366064),
(640,	'vi',	'themes',	'Sửa block',	'Name : Menu top header',	'',	1,	1629366181),
(641,	'vi',	'login',	'[admin] Thoát khỏi tài khoản Quản trị',	' Client IP:127.0.0.1',	'',	1,	1629366753);

DROP TABLE IF EXISTS `qd_notification`;
CREATE TABLE `qd_notification` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `admin_view_allowed` tinyint(1) unsigned NOT NULL DEFAULT 0 COMMENT 'Cấp quản trị được xem: 0,1,2',
  `logic_mode` tinyint(1) unsigned NOT NULL DEFAULT 0 COMMENT '0: Cấp trên xem được cấp dưới, 1: chỉ cấp hoặc người được chỉ định',
  `send_to` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Danh sách id người nhận, phân cách bởi dấu phảy',
  `send_from` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `area` tinyint(1) unsigned NOT NULL,
  `language` char(3) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `obid` int(11) unsigned NOT NULL DEFAULT 0,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `add_time` int(11) unsigned NOT NULL,
  `view` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `send_to` (`send_to`),
  KEY `admin_view_allowed` (`admin_view_allowed`),
  KEY `logic_mode` (`logic_mode`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_notification`;

DROP TABLE IF EXISTS `qd_plugin`;
CREATE TABLE `qd_plugin` (
  `pid` tinyint(4) NOT NULL AUTO_INCREMENT,
  `plugin_file` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `plugin_area` tinyint(4) NOT NULL,
  `weight` tinyint(4) NOT NULL,
  PRIMARY KEY (`pid`),
  UNIQUE KEY `plugin_file` (`plugin_file`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_plugin`;
INSERT INTO `qd_plugin` (`pid`, `plugin_file`, `plugin_area`, `weight`) VALUES
(1,	'qrcode.php',	1,	2),
(2,	'cdn_js_css_image.php',	3,	1),
(3,	'redirect_to_non_www.php',	1,	1);

DROP TABLE IF EXISTS `qd_sessions`;
CREATE TABLE `qd_sessions` (
  `session_id` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `onl_time` int(11) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `session_id` (`session_id`),
  KEY `onl_time` (`onl_time`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_sessions`;
INSERT INTO `qd_sessions` (`session_id`, `userid`, `username`, `onl_time`) VALUES
('kjgtaee1rj9hfh2bm11nvasa4f',	0,	'guest',	1629366985);

DROP TABLE IF EXISTS `qd_setup_extensions`;
CREATE TABLE `qd_setup_extensions` (
  `id` int(11) NOT NULL DEFAULT 0,
  `type` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'other',
  `title` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_sys` tinyint(1) NOT NULL DEFAULT 0,
  `is_virtual` tinyint(1) NOT NULL DEFAULT 0,
  `basename` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table_prefix` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `addtime` int(11) NOT NULL DEFAULT 0,
  `author` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  UNIQUE KEY `title` (`type`,`title`),
  KEY `id` (`id`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_setup_extensions`;
INSERT INTO `qd_setup_extensions` (`id`, `type`, `title`, `is_sys`, `is_virtual`, `basename`, `table_prefix`, `version`, `addtime`, `author`, `note`) VALUES
(0,	'module',	'blog',	0,	0,	'news',	'blog',	'',	1598170310,	'',	''),
(19,	'module',	'banners',	1,	0,	'banners',	'banners',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(1,	'module',	'news',	0,	1,	'news',	'news',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(21,	'module',	'voting',	0,	0,	'voting',	'voting',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(284,	'module',	'seek',	1,	0,	'seek',	'seek',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(24,	'module',	'users',	1,	1,	'users',	'users',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(27,	'module',	'statistics',	0,	0,	'statistics',	'statistics',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(29,	'module',	'menu',	0,	0,	'menu',	'menu',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(283,	'module',	'feeds',	1,	0,	'feeds',	'feeds',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(282,	'module',	'page',	1,	1,	'page',	'page',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(281,	'module',	'comment',	1,	0,	'comment',	'comment',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(327,	'module',	'two-step-verification',	1,	0,	'two-step-verification',	'two_step_verification',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(307,	'theme',	'default',	0,	0,	'default',	'default',	'4.4.02 1592816400',	1596205058,	'VINADES <contact@vinades.vn>',	''),
(137,	'module',	'home',	0,	0,	'home',	'home',	'3.4.01 1596211130',	1596211130,	'hoaquynhtim99 (phantandung92@gmail.com)',	'Module dùng làm trang chủ cho những website sử dụng block để làm homepage.'),
(0,	'theme',	'huynhquocdat',	0,	0,	'huynhquocdat',	'huynhquocdat',	'4.4.02 1626338782',	1626338782,	'Quốc Đạt IT',	'Đây là giao diện mặc định của hệ thống. Bạn không được xóa, đổi tên và không nên sửa trực tiếp vào giao diện này. Nếu muốn, hãy copy thành giao diện khác và kích hoạt sử dụng giao diện mới đó để chỉnh sửa và sử dụng.'),
(0,	'module',	'newsnotice',	0,	1,	'newsnotice',	'newsnotice',	'1.0.00 1395235974',	1626340864,	'mynukeviet (contact@mynukeviet.com)',	'');

DROP TABLE IF EXISTS `qd_setup_language`;
CREATE TABLE `qd_setup_language` (
  `lang` char(2) COLLATE utf8mb4_unicode_ci NOT NULL,
  `setup` tinyint(1) NOT NULL DEFAULT 0,
  `weight` smallint(4) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_setup_language`;
INSERT INTO `qd_setup_language` (`lang`, `setup`, `weight`) VALUES
('vi',	1,	1);

DROP TABLE IF EXISTS `qd_shops_field_value_vi`;
CREATE TABLE `qd_shops_field_value_vi` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `rows_id` int(11) unsigned NOT NULL,
  `field_id` mediumint(8) NOT NULL,
  `field_value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `rows_id` (`rows_id`,`field_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_shops_field_value_vi`;

DROP TABLE IF EXISTS `qd_upload_dir`;
CREATE TABLE `qd_upload_dir` (
  `did` mediumint(8) NOT NULL AUTO_INCREMENT,
  `dirname` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `time` int(11) NOT NULL DEFAULT 0,
  `thumb_type` tinyint(4) NOT NULL DEFAULT 0,
  `thumb_width` smallint(6) NOT NULL DEFAULT 0,
  `thumb_height` smallint(6) NOT NULL DEFAULT 0,
  `thumb_quality` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`did`),
  UNIQUE KEY `name` (`dirname`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_upload_dir`;
INSERT INTO `qd_upload_dir` (`did`, `dirname`, `time`, `thumb_type`, `thumb_width`, `thumb_height`, `thumb_quality`) VALUES
(0,	'',	0,	3,	600,	500,	99),
(9,	'uploads',	1628675349,	0,	0,	0,	0),
(10,	'uploads/banners',	1598447787,	0,	0,	0,	0),
(11,	'uploads/banners/files',	1598447788,	0,	0,	0,	0),
(12,	'uploads/blog',	1626068461,	0,	0,	0,	0),
(13,	'uploads/blog/2020_08',	1598180563,	0,	0,	0,	0),
(14,	'uploads/blog/source',	1598180564,	0,	0,	0,	0),
(15,	'uploads/blog/temp_pic',	1598180564,	0,	0,	0,	0),
(16,	'uploads/blog/topics',	1598180565,	0,	0,	0,	0),
(17,	'uploads/comment',	1598447795,	0,	0,	0,	0),
(19,	'uploads/menu',	1598447797,	0,	0,	0,	0),
(20,	'uploads/page',	1598447798,	0,	0,	0,	0),
(21,	'uploads/trang',	1598447798,	0,	0,	0,	0),
(22,	'uploads/users',	1598447799,	0,	0,	0,	0),
(23,	'uploads/users/groups',	1598447800,	0,	0,	0,	0),
(24,	'uploads/blog/2020_09',	1599318224,	0,	0,	0,	0),
(25,	'uploads/blog/2021_01',	1611716254,	0,	0,	0,	0),
(26,	'uploads/blog/2021_04',	1617717437,	0,	0,	0,	0),
(27,	'uploads/blog/2021_07',	1625843455,	0,	0,	0,	0),
(29,	'uploads/newsnotice',	0,	0,	0,	0,	0),
(30,	'uploads/comment/2021_07',	0,	0,	0,	0,	0),
(32,	'uploads/blog/2021_08',	1627807761,	0,	0,	0,	0);

DROP TABLE IF EXISTS `qd_upload_file`;
CREATE TABLE `qd_upload_file` (
  `name` varchar(245) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ext` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type` varchar(5) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `filesize` int(11) NOT NULL DEFAULT 0,
  `src` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `srcwidth` int(11) NOT NULL DEFAULT 0,
  `srcheight` int(11) NOT NULL DEFAULT 0,
  `sizes` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `mtime` int(11) NOT NULL DEFAULT 0,
  `did` int(11) NOT NULL DEFAULT 0,
  `title` varchar(245) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alt` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  UNIQUE KEY `did` (`did`,`title`),
  KEY `userid` (`userid`),
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_upload_file`;
INSERT INTO `qd_upload_file` (`name`, `ext`, `type`, `filesize`, `src`, `srcwidth`, `srcheight`, `sizes`, `userid`, `mtime`, `did`, `title`, `alt`) VALUES
('avatar.jpg',	'jpg',	'image',	72861,	'assets/avatar.jpg',	80,	80,	'665|665',	1,	1593272441,	9,	'avatar.jpg',	'avatar'),
('logo_2830e...png',	'png',	'image',	4873,	'assets/logo_2830ebe044cff068e5511040870ccf01.png',	80,	33,	'144|59',	1,	1598046223,	9,	'logo_2830ebe044cff068e5511040870ccf01.png',	'logo 2830ebe044cff068e5511040870ccf01'),
('nukeviet.jpg',	'jpg',	'image',	144962,	'assets/blog/2020_08/nukeviet.jpg',	80,	37,	'1153|530',	1,	1597994456,	13,	'nukeviet.jpg',	'nukeviet'),
('vinades.jpg',	'jpg',	'image',	104940,	'assets/banners/vinades.jpg',	43,	80,	'212|400',	1,	1596341411,	10,	'vinades.jpg',	'vinades'),
('webnhanh.jpg',	'jpg',	'image',	74347,	'assets/banners/webnhanh.jpg',	80,	10,	'572|72',	1,	1596341411,	10,	'webnhanh.jpg',	'webnhanh'),
('thao-tung-...jpg',	'jpg',	'image',	53332,	'assets/blog/2020_08/thao-tung-tam-ly.jpg',	80,	45,	'625|351',	1,	1598448140,	13,	'thao-tung-tam-ly.jpg',	'thao tung tam ly'),
('barnum-fea...jpg',	'jpg',	'image',	392754,	'assets/blog/2020_08/barnum-feature.jpg',	80,	45,	'1500|843',	1,	1598541779,	13,	'barnum-feature.jpg',	'barnum feature'),
('han-gan-vo...jpg',	'jpg',	'image',	356049,	'assets/blog/2020_08/han-gan-voi-ba-me-feature.jpg',	80,	53,	'1500|1000',	1,	1598542278,	13,	'han-gan-voi-ba-me-feature.jpg',	'han gan voi ba me feature'),
('25-thuat-t...jpg',	'jpg',	'image',	173189,	'assets/blog/2020_09/25-thuat-tam-ly.jpg',	80,	42,	'1000|525',	1,	1625844872,	24,	'25-thuat-tam-ly.jpg',	'25 thuat tam ly'),
('fix_module...zip',	'zip',	'file',	13893,	'assets/images/zip.gif',	32,	32,	'|',	1,	1625932976,	27,	'fix_module_shops_nukeviet.zip',	'fix module shops nukeviet'),
('chau-a-doi...jpg',	'jpg',	'image',	68252,	'assets/blog/2020_09/chau-a-doi-moi-cong-nghe-hay-la-chet.jpg',	80,	50,	'650|406',	1,	1599318713,	24,	'chau-a-doi-moi-cong-nghe-hay-la-chet.jpg',	'chau a doi moi cong nghe hay la chet'),
('nghe-lap-t...jpg',	'jpg',	'image',	53623,	'assets/blog/2020_09/nghe-lap-trinh-va-nhung-su-that-it-nguoi-biet.jpg',	80,	53,	'849|566',	1,	1599319228,	24,	'nghe-lap-trinh-va-nhung-su-that-it-nguoi-biet.jpg',	'nghe lap trinh va nhung su that it nguoi biet'),
('4-quy-tac-...jpg',	'jpg',	'image',	83225,	'assets/blog/2020_09/4-quy-tac-cua-ly-tieu-long-de-hinh-thanh-tinh-than-thep-huong-thien.jpg',	80,	48,	'680|408',	1,	1599319527,	24,	'4-quy-tac-cua-ly-tieu-long-de-hinh-thanh-tinh-than-thep-huong-thien.jpg',	'4 quy tac cua ly tieu long de hinh thanh tinh than thep huong thien'),
('bi-quyet-d...jpg',	'jpg',	'image',	230108,	'assets/blog/2020_09/bi-quyet-de-moi-quan-he-dai-lau.jpg',	80,	45,	'1500|843',	1,	1600578579,	24,	'bi-quyet-de-moi-quan-he-dai-lau.jpg',	'bi quyet de moi quan he dai lau'),
('google-http-2.jpg',	'jpg',	'image',	50061,	'assets/blog/2020_09/google-http-2.jpg',	80,	42,	'700|368',	1,	1600731539,	24,	'google-http-2.jpg',	'google http 2'),
('bien-tap-c...jpg',	'jpg',	'image',	107214,	'assets/blog/2021_01/bien-tap-cuoc-doi-chinh-phuc-muc-tieu-moi-2021.jpg',	80,	42,	'1000|525',	1,	1625844303,	25,	'bien-tap-cuoc-doi-chinh-phuc-muc-tieu-moi-2021.jpg',	'bien tap cuoc doi chinh phuc muc tieu moi 2021'),
('fullstack.png',	'png',	'image',	24847,	'assets/blog/2021_04/fullstack.png',	80,	46,	'696|400',	1,	1617717443,	26,	'fullstack.png',	'fullstack'),
('logo-huynh...jpg',	'jpg',	'image',	91002,	'assets/logo-huynhquocdat.jpg',	80,	80,	'1200|1200',	1,	1625823145,	9,	'logo-huynhquocdat.jpg',	'logo-huynhquocdat'),
('danh-dum-t...jpg',	'jpg',	'image',	291417,	'assets/blog/2021_07/danh-dum-tien-nhu-the-nao-de-duoc-nghi-huu-som.jpg',	80,	42,	'1000|525',	1,	1625843464,	27,	'danh-dum-tien-nhu-the-nao-de-duoc-nghi-huu-som.jpg',	'danh dum tien nhu the nao de duoc nghi huu som'),
('image-202...jpeg',	'jpeg',	'image',	36817,	'assets/blog/2021_07/image-20210709221107-1.jpeg',	80,	25,	'700|218',	1,	1625843495,	27,	'image-20210709221107-1.jpeg',	'image 20210709221107 1'),
('image-202...jpeg',	'jpeg',	'image',	53584,	'assets/blog/2021_07/image-20210709221107-2.jpeg',	80,	51,	'700|442',	1,	1625843496,	27,	'image-20210709221107-2.jpeg',	'image 20210709221107 2'),
('huong-dan-...jpg',	'jpg',	'image',	182167,	'assets/blog/2021_07/huong-dan-sua-loi-cho-module-shop-nukeviet.jpg',	80,	42,	'1000|525',	1,	1625933481,	27,	'huong-dan-sua-loi-cho-module-shop-nukeviet.jpg',	'huong dan sua loi cho module shop nukeviet'),
('10-nhom-kh...jpg',	'jpg',	'image',	285435,	'assets/blog/2021_07/10-nhom-khach-hang-thuong-gap.jpg',	80,	42,	'1000|525',	1,	1626000077,	27,	'10-nhom-khach-hang-thuong-gap.jpg',	'10 nhom khach hang thuong gap'),
('xu-huong-c...jpg',	'jpg',	'image',	336661,	'assets/blog/2021_07/xu-huong-cong-nghe.jpg',	80,	42,	'1000|525',	1,	1626022350,	27,	'xu-huong-cong-nghe.jpg',	'xu huong cong nghe'),
('image-202...jpeg',	'jpeg',	'image',	40096,	'assets/blog/2021_07/image-20210713095026-2.jpeg',	80,	43,	'600|321',	1,	1626144654,	27,	'image-20210713095026-2.jpeg',	'image 20210713095026 2'),
('image-202...jpeg',	'jpeg',	'image',	68260,	'assets/blog/2021_07/image-20210713095026-1.jpeg',	80,	33,	'1431|595',	1,	1626144655,	27,	'image-20210713095026-1.jpeg',	'image 20210713095026 1'),
('image-202...jpeg',	'jpeg',	'image',	100408,	'assets/blog/2021_07/image-20210713095043-3.jpeg',	80,	53,	'1200|801',	1,	1626144671,	27,	'image-20210713095043-3.jpeg',	'image 20210713095043 3'),
('image-2021...png',	'png',	'image',	556707,	'assets/blog/2021_07/image-20210713095043-4.png',	80,	45,	'780|439',	1,	1626144671,	27,	'image-20210713095043-4.png',	'image 20210713095043 4'),
('image-2021...png',	'png',	'image',	172841,	'assets/blog/2021_07/image-20210713095101-6.png',	80,	44,	'900|500',	1,	1626144689,	27,	'image-20210713095101-6.png',	'image 20210713095101 6'),
('image-202...jpeg',	'jpeg',	'image',	133437,	'assets/blog/2021_07/image-20210713095101-5.jpeg',	80,	45,	'1280|720',	1,	1626144690,	27,	'image-20210713095101-5.jpeg',	'image 20210713095101 5'),
('lo-trinh-p...jpg',	'jpg',	'image',	148318,	'assets/blog/2021_07/lo-trinh-phat-trien-software-engineer.jpg',	80,	42,	'1000|525',	1,	1626145425,	27,	'lo-trinh-phat-trien-software-engineer.jpg',	'lo trinh phat trien software engineer'),
('tips-meo-d...jpg',	'jpg',	'image',	215206,	'assets/blog/2021_07/tips-meo-danh-cho-lap-trinh-vien-nukeviet-cms.jpg',	80,	42,	'1000|525',	1,	1626174388,	27,	'tips-meo-danh-cho-lap-trinh-vien-nukeviet-cms.jpg',	'tips meo danh cho lap trinh vien nukeviet cms'),
('cong-ty-th...jpg',	'jpg',	'image',	306994,	'assets/blog/2021_07/cong-ty-thiet-ke-website-tai-nha-trang-khanh-hoa.jpg',	80,	42,	'1000|525',	1,	1626268857,	27,	'cong-ty-thiet-ke-website-tai-nha-trang-khanh-hoa.jpg',	'cong ty thiet ke website tai nha trang khanh hoa'),
('dich-vu-ma...jpg',	'jpg',	'image',	288070,	'assets/blog/2021_07/dich-vu-marketing-online-nha-trang-khanh-hoa.jpg',	80,	42,	'1000|525',	1,	1626270417,	27,	'dich-vu-marketing-online-nha-trang-khanh-hoa.jpg',	'dich vu marketing online nha trang khanh hoa'),
('60-cach-ca...jpg',	'jpg',	'image',	418024,	'assets/blog/2021_07/60-cach-cai-thien-ban-than-trong-100-ngay.jpg',	80,	42,	'1000|525',	1,	1626364508,	27,	'60-cach-cai-thien-ban-than-trong-100-ngay.jpg',	'60 cach cai thien ban than trong 100 ngay'),
('nukeviet-cms.jpg',	'jpg',	'image',	254698,	'assets/blog/nukeviet-cms.jpg',	80,	42,	'1000|525',	1,	1626577212,	12,	'nukeviet-cms.jpg',	'nukeviet cms'),
('nukeviet-4...jpg',	'jpg',	'image',	287469,	'assets/blog/2021_07/nukeviet-4-5-co-gi-moi.jpg',	80,	42,	'1000|525',	1,	1626745347,	27,	'nukeviet-4-5-co-gi-moi.jpg',	'nukeviet 4 5 co gi moi'),
('tieu-chuan...jpg',	'jpg',	'image',	252318,	'assets/blog/2021_07/tieu-chuan-bao-mat-owasp.jpg',	80,	42,	'1000|525',	1,	1626749269,	27,	'tieu-chuan-bao-mat-owasp.jpg',	'tieu chuan bao mat owasp'),
('thuc-tap-l...jpg',	'jpg',	'image',	292909,	'assets/blog/2021_07/thuc-tap-lap-trinh-som.jpg',	80,	42,	'1000|525',	1,	1627096932,	27,	'thuc-tap-lap-trinh-som.jpg',	'thuc tap lap trinh som'),
('xay-dung-c...jpg',	'jpg',	'image',	319756,	'assets/blog/2021_07/xay-dung-chan-dung-khach-hang.jpg',	80,	42,	'1000|525',	1,	1627371778,	27,	'xay-dung-chan-dung-khach-hang.jpg',	'xay dung chan dung khach hang'),
('buyer-persona.png',	'png',	'image',	175464,	'assets/blog/2021_07/buyer-persona.png',	80,	63,	'1200|950',	1,	1627372312,	27,	'buyer-persona.png',	'Buyer persona'),
('image.png',	'png',	'image',	249680,	'assets/blog/2021_07/image.png',	80,	65,	'720|582',	1,	1627372765,	27,	'image.png',	'image'),
('image_1.png',	'png',	'image',	292110,	'assets/blog/2021_07/image_1.png',	80,	45,	'698|394',	1,	1627372816,	27,	'image_1.png',	'image 1'),
('image_2.png',	'png',	'image',	821408,	'assets/blog/2021_07/image_2.png',	76,	80,	'632|667',	1,	1627372937,	27,	'image_2.png',	'image 2'),
('customer-...xlsx',	'xlsx',	'file',	583642,	'assets/images/excel.png',	32,	32,	'|',	1,	1627373262,	27,	'customer-persona-template-abc-digi.xlsx',	'Customer Persona Template   ABC Digi'),
('cau-truc-d...jpg',	'jpg',	'image',	309608,	'assets/blog/2021_07/cau-truc-du-lieu-va-giai-thuat.jpg',	80,	42,	'1000|525',	1,	1627639016,	27,	'cau-truc-du-lieu-va-giai-thuat.jpg',	'cau truc du lieu va giai thuat'),
('image-2021...png',	'png',	'image',	19691,	'assets/blog/2021_08/image-20210801153947-1.png',	80,	33,	'509|212',	1,	1627807191,	32,	'image-20210801153947-1.png',	'image 20210801153947 1'),
('image-2021...png',	'png',	'image',	28716,	'assets/blog/2021_08/image-20210801154225-2.png',	80,	61,	'506|387',	1,	1627807348,	32,	'image-20210801154225-2.png',	'image 20210801154225 2'),
('image-2021...png',	'png',	'image',	37015,	'assets/blog/2021_08/image-20210801154225-4.png',	79,	80,	'614|620',	1,	1627807349,	32,	'image-20210801154225-4.png',	'image 20210801154225 4'),
('image-2021...png',	'png',	'image',	19567,	'assets/blog/2021_08/image-20210801154225-5.png',	77,	80,	'454|473',	1,	1627807349,	32,	'image-20210801154225-5.png',	'image 20210801154225 5'),
('image-2021...png',	'png',	'image',	24147,	'assets/blog/2021_08/image-20210801154225-7.png',	80,	41,	'884|451',	1,	1627807349,	32,	'image-20210801154225-7.png',	'image 20210801154225 7'),
('image-2021...png',	'png',	'image',	31480,	'assets/blog/2021_08/image-20210801154225-6.png',	80,	54,	'561|380',	1,	1627807349,	32,	'image-20210801154225-6.png',	'image 20210801154225 6'),
('image-2021...png',	'png',	'image',	53508,	'assets/blog/2021_08/image-20210801154225-3.png',	80,	26,	'907|299',	1,	1627807349,	32,	'image-20210801154225-3.png',	'image 20210801154225 3'),
('huong-dan-...jpg',	'jpg',	'image',	155289,	'assets/blog/2021_08/huong-dan-tuy-bien-module-lien-he-nukeviet-cms-2.jpg',	80,	42,	'770|404',	1,	1627812541,	32,	'huong-dan-tuy-bien-module-lien-he-nukeviet-cms-2.jpg',	'huong dan tuy bien module lien he nukeviet cms'),
('seo-01.png',	'png',	'image',	898680,	'assets/blog/2021_07/seo-01.png',	80,	48,	'1500|898',	1,	1628300035,	27,	'seo-01.png',	'seo 01'),
('hoc-thuat-...jpg',	'jpg',	'image',	305031,	'assets/blog/2021_08/hoc-thuat-toan-the-nao-cho-hieu-qua.jpg',	80,	42,	'1000|525',	1,	1628591769,	32,	'hoc-thuat-toan-the-nao-cho-hieu-qua.jpg',	'học thuật toán thế nào cho hiệu quả'),
('cac-kho-kh...jpg',	'jpg',	'image',	302103,	'assets/blog/2021_08/cac-kho-khan-ban-co-the-gap-khi-hoc-cong-nghe-thong-tin.jpg',	80,	42,	'1000|525',	1,	1628664870,	32,	'cac-kho-khan-ban-co-the-gap-khi-hoc-cong-nghe-thong-tin.jpg',	'các khó khăn bạn có thể gặp khi học công nghệ thông tin'),
('logo_c2cff...png',	'png',	'image',	4873,	'assets/logo_c2cff4f25b2fe6e7d3c9e3882c36750c.png',	80,	33,	'144|59',	1,	1599177889,	9,	'logo_c2cff4f25b2fe6e7d3c9e3882c36750c.png',	'logo c2cff4f25b2fe6e7d3c9e3882c36750c'),
('logo-huynh...jpg',	'jpg',	'image',	10394,	'assets/logo-huynhquocdat_865ab6b8cf95a3d9f377b16ecf51c3dd.jpg',	80,	80,	'144|144',	1,	1625846704,	9,	'logo-huynhquocdat_865ab6b8cf95a3d9f377b16ecf51c3dd.jpg',	'logo huynhquocdat 865ab6b8cf95a3d9f377b16ecf51c3dd'),
('default-image.png',	'png',	'image',	9730,	'assets/default-image.png',	80,	45,	'720|405',	1,	1598180635,	9,	'default-image.png',	'default image'),
('favicon.ico',	'ico',	'image',	9662,	'assets/favicon.ico',	48,	48,	'48|48',	1,	1628675356,	9,	'favicon.ico',	'favicon'),
('cong-ty-th...jpg',	'jpg',	'image',	306103,	'assets/blog/2021_07/cong-ty-thiet-ke-website-chuan-seo-tai-nha-trang-khanh-hoa.jpg',	80,	42,	'1000|525',	1,	1628686366,	27,	'cong-ty-thiet-ke-website-chuan-seo-tai-nha-trang-khanh-hoa.jpg',	'Công ty Thiết kế website Chuẩn SEO tại Nha Trang Khánh Hòa'),
('nhung-thu-...jpg',	'jpg',	'image',	51515,	'assets/blog/2021_08/nhung-thu-minh-co-la-gia-tri.jpg',	80,	50,	'563|353',	1,	1628751570,	32,	'nhung-thu-minh-co-la-gia-tri.jpg',	'nhung thu minh co la gia tri'),
('can-bang-c...jpg',	'jpg',	'image',	77139,	'assets/blog/2021_08/can-bang-cuoc-song.jpg',	80,	41,	'678|349',	1,	1628751682,	32,	'can-bang-cuoc-song.jpg',	'can bang cuoc song'),
('tu-duy-nguoc.jpg',	'jpg',	'image',	285834,	'assets/blog/2021_08/tu-duy-nguoc.jpg',	80,	45,	'1280|720',	1,	1628751795,	32,	'tu-duy-nguoc.jpg',	'tu duy nguoc'),
('7-cach-de-...jpg',	'jpg',	'image',	308168,	'assets/blog/2021_08/7-cach-de-song-tich-cuc-hon.jpg',	80,	42,	'1000|525',	1,	1628753080,	32,	'7-cach-de-song-tich-cuc-hon.jpg',	'7 cách để sống tích cực hơn'),
('nukeviet-c...jpg',	'jpg',	'image',	277120,	'assets/blog/2021_08/nukeviet-cms-la-gi.jpg',	80,	42,	'1000|525',	1,	1628756184,	32,	'nukeviet-cms-la-gi.jpg',	'nukeviet cms la gi'),
('thong-bao-...jpg',	'jpg',	'image',	288724,	'assets/blog/2021_08/thong-bao-phat-hanh-nukeviet-4.5.00.jpg',	80,	42,	'1000|525',	1,	1628787340,	32,	'thong-bao-phat-hanh-nukeviet-4.5.00.jpg',	'thông báo phát hành nukeviet 4 5 00'),
('bat-dau-kh...jpg',	'jpg',	'image',	19394,	'assets/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-2.jpg',	80,	45,	'800|453',	1,	1628874911,	32,	'bat-dau-khoi-nghiep-kieu-gi-start-up-2.jpg',	'bat dau khoi nghiep kieu gi start up 2'),
('bat-dau-kh...jpg',	'jpg',	'image',	30827,	'assets/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-3.jpg',	80,	53,	'800|527',	1,	1628874961,	32,	'bat-dau-khoi-nghiep-kieu-gi-start-up-3.jpg',	'bat dau khoi nghiep kieu gi start up 3'),
('bat-dau-kh...jpg',	'jpg',	'image',	17678,	'assets/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-5.jpg',	80,	33,	'800|333',	1,	1628875005,	32,	'bat-dau-khoi-nghiep-kieu-gi-start-up-5.jpg',	'bat dau khoi nghiep kieu gi start up 5'),
('bat-dau-kh...jpg',	'jpg',	'image',	15566,	'assets/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-start-up-4.jpg',	80,	60,	'800|599',	1,	1628875073,	32,	'bat-dau-khoi-nghiep-kieu-gi-start-up-4.jpg',	'bat dau khoi nghiep kieu gi start up 4'),
('bat-dau-kh...jpg',	'jpg',	'image',	258737,	'assets/blog/2021_08/bat-dau-khoi-nghiep-kieu-gi-chua-biet-nhung-dieu-nay-thi-dung-mo-khoi-nghiep-nhe.jpg',	80,	42,	'1000|525',	1,	1628875846,	32,	'bat-dau-khoi-nghiep-kieu-gi-chua-biet-nhung-dieu-nay-thi-dung-mo-khoi-nghiep-nhe.jpg',	'Bắt đầu khởi nghiệp kiểu gì – Chưa biết những điều này thì đừng mơ khởi nghiệp nhé'),
('nukeviet-c...jpg',	'jpg',	'image',	277120,	'assets/blog/topics/nukeviet-cms-la-gi.jpg',	80,	42,	'1000|525',	1,	1628912667,	16,	'nukeviet-cms-la-gi.jpg',	'nukeviet cms la gi'),
('huong-dan-...jpg',	'jpg',	'image',	264127,	'assets/blog/2021_08/huong-dan-tuy-bien-module-lien-he.jpg',	80,	42,	'1000|525',	1,	1628913787,	32,	'huong-dan-tuy-bien-module-lien-he.jpg',	'Hướng dẫn tùy biến Module Liên hệ'),
('tips-meo-d...jpg',	'jpg',	'image',	282858,	'assets/blog/2021_07/tips-meo-danh-cho-lap-trinh-vien-nukeviet-cms_1.jpg',	80,	42,	'1000|525',	1,	1628913975,	27,	'tips-meo-danh-cho-lap-trinh-vien-nukeviet-cms_1.jpg',	'tips meo danh cho lap trinh vien nukeviet cms'),
('nukeviet-4...jpg',	'jpg',	'image',	263863,	'assets/blog/2021_07/nukeviet-4-5-co-gi-moi_1.jpg',	80,	42,	'1000|525',	1,	1628914257,	27,	'nukeviet-4-5-co-gi-moi_1.jpg',	'nukeviet 4 5 co gi moi'),
('huong-dan-...jpg',	'jpg',	'image',	256244,	'assets/blog/2021_07/huong-dan-sua-loi-cho-module-shop-nukeviet_1.jpg',	80,	42,	'1000|525',	1,	1628914396,	27,	'huong-dan-sua-loi-cho-module-shop-nukeviet_1.jpg',	'huong dan sua loi cho module shop nukeviet'),
('nukeviet-c...jpg',	'jpg',	'image',	277120,	'assets/blog/nukeviet-cms-la-gi.jpg',	80,	42,	'1000|525',	1,	1628914458,	12,	'nukeviet-cms-la-gi.jpg',	'nukeviet cms la gi'),
('6-thoi-que...jpg',	'jpg',	'image',	200857,	'assets/blog/2021_08/6-thoi-quen-xau-anh-huong-den-su-nghiep-cua-ban.jpg',	80,	42,	'1000|525',	1,	1628967316,	32,	'6-thoi-quen-xau-anh-huong-den-su-nghiep-cua-ban.jpg',	'6 thói quen xấu ảnh hưởng đến sự nghiệp của bạn'),
('untitled-d...png',	'png',	'image',	192320,	'assets/blog/2021_08/untitled-design-34.png',	80,	60,	'1200|900',	1,	1629262188,	32,	'untitled-design-34.png',	'Untitled design 34'),
('list-sach-...png',	'png',	'image',	342974,	'assets/blog/2021_08/list-sach-hay-ve-tam-nhin-cover-780x470.png',	80,	48,	'780|470',	1,	1629262364,	32,	'list-sach-hay-ve-tam-nhin-cover-780x470.png',	'list sach hay ve tam nhin cover 780x470'),
('7-loai-con...jpg',	'jpg',	'image',	299140,	'assets/blog/2021_08/7-loai-cong-ty-se-khong-bao-gio-kha-len-duoc.jpg',	80,	42,	'1000|525',	1,	1629262789,	32,	'7-loai-cong-ty-se-khong-bao-gio-kha-len-duoc.jpg',	'7 loại công ty sẽ không bao giờ khá lên được');

DROP TABLE IF EXISTS `qd_users`;
CREATE TABLE `qd_users` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `group_id` smallint(5) unsigned NOT NULL DEFAULT 0,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `md5username` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `last_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `gender` char(1) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `birthday` int(11) NOT NULL,
  `sig` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `regdate` int(11) NOT NULL DEFAULT 0,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `passlostkey` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `view_mail` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `remember` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `in_groups` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `active` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `active2step` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `secretkey` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `checknum` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `last_login` int(11) unsigned NOT NULL DEFAULT 0,
  `last_ip` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `last_agent` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `last_openid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `last_update` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'Thời điểm cập nhật thông tin lần cuối',
  `idsite` int(11) NOT NULL DEFAULT 0,
  `safemode` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `safekey` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `email_verification_time` int(11) NOT NULL DEFAULT -1 COMMENT '-3: Tài khoản sys, -2: Admin kích hoạt, -1 không cần kích hoạt, 0: Chưa xác minh, > 0 thời gian xác minh',
  `active_obj` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'SYSTEM' COMMENT 'SYSTEM, EMAIL, OAUTH:xxxx, quản trị kích hoạt thì lưu userid',
  PRIMARY KEY (`userid`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `md5username` (`md5username`),
  UNIQUE KEY `email` (`email`),
  KEY `idsite` (`idsite`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users`;
INSERT INTO `qd_users` (`userid`, `group_id`, `username`, `md5username`, `password`, `email`, `first_name`, `last_name`, `gender`, `photo`, `birthday`, `sig`, `regdate`, `question`, `answer`, `passlostkey`, `view_mail`, `remember`, `in_groups`, `active`, `active2step`, `secretkey`, `checknum`, `last_login`, `last_ip`, `last_agent`, `last_openid`, `last_update`, `idsite`, `safemode`, `safekey`, `email_verification_time`, `active_obj`) VALUES
(1,	1,	'admin',	'21232f297a57a5a743894a0e4a801fc3',	'{SSHA512}6z30Y1WnkfXUM7AIbrLqLLToyhyn29RjcsgVFMD0OQMD87CSrmsYcD/W75qAGlpmxgjLFO6YVk3Z/kmjLEqUHzk3NTA=',	'admin@admin.com',	'Admin',	'',	'M',	'',	841165200,	'',	1598170079,	'Câu hỏi 2021',	'Trả lời 2021',	'',	0,	1,	'1,4',	1,	0,	'',	'',	1598170079,	'',	'',	'',	1629365492,	0,	0,	'',	0,	'SYSTEM');

DROP TABLE IF EXISTS `qd_users_backupcodes`;
CREATE TABLE `qd_users_backupcodes` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_used` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `time_used` int(11) unsigned NOT NULL DEFAULT 0,
  `time_creat` int(11) unsigned NOT NULL DEFAULT 0,
  UNIQUE KEY `userid` (`userid`,`code`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_backupcodes`;

DROP TABLE IF EXISTS `qd_users_config`;
CREATE TABLE `qd_users_config` (
  `config` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `edit_time` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`config`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_config`;
INSERT INTO `qd_users_config` (`config`, `content`, `edit_time`) VALUES
('access_admin',	'a:8:{s:15:\"access_viewlist\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:12:\"access_addus\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:14:\"access_waiting\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:17:\"access_editcensor\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:13:\"access_editus\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:12:\"access_delus\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:13:\"access_passus\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}s:13:\"access_groups\";a:3:{i:1;b:1;i:2;b:1;i:3;b:1;}}',	1625649945),
('password_simple',	'000000|1234|2000|12345|111111|123123|123456|654321|696969|1234567|1234569|11223344|12345678|12345679|23456789|66666666|66668888|68686868|87654321|88888888|99999999|123456789|999999999|1234567890|aaaaaa|abc123|abc123@|abc@123|admin123|admin123@|admin@123|adobe1|adobe123|azerty|baseball|dragon|football|harley|hoilamgi|iloveyou|jennifer|jordan|khongbiet|khongco|khongcopass|letmein|macromedia|master|michael|monkey|mustang|nuke123|nuke123@|nuke@123|password|photoshop|pussy|qwerty|shadow|superman',	1625649945),
('deny_email',	'yoursite.com|mysite.com|localhost|xxx',	1625649945),
('deny_name',	'anonimo|anonymous|god|linux|nobody|operator|root',	1625649945),
('avatar_width',	'80',	1625649945),
('avatar_height',	'80',	1625649945),
('active_group_newusers',	'0',	1625649945),
('active_editinfo_censor',	'0',	1625649945),
('active_user_logs',	'1',	1625649945),
('min_old_user',	'16',	1625649945),
('register_active_time',	'86400',	1596205058),
('siteterms_vi',	'<p> Để trở thành thành viên, bạn phải cam kết đồng ý với các điều khoản dưới đây. Chúng tôi có thể thay đổi lại những điều khoản này vào bất cứ lúc nào và chúng tôi sẽ cố gắng thông báo đến bạn kịp thời.<br /> <br /> Bạn cam kết không gửi bất cứ bài viết có nội dung lừa đảo, thô tục, thiếu văn hoá; vu khống, khiêu khích, đe doạ người khác; liên quan đến các vấn đề tình dục hay bất cứ nội dung nào vi phạm luật pháp của quốc gia mà bạn đang sống, luật pháp của quốc gia nơi đặt máy chủ của website này hay luật pháp quốc tế. Nếu vẫn cố tình vi phạm, ngay lập tức bạn sẽ bị cấm tham gia vào website. Địa chỉ IP của tất cả các bài viết đều được ghi nhận lại để bảo vệ các điều khoản cam kết này trong trường hợp bạn không tuân thủ.<br /> <br /> Bạn đồng ý rằng website có quyền gỡ bỏ, sửa, di chuyển hoặc khoá bất kỳ bài viết nào trong website vào bất cứ lúc nào tuỳ theo nhu cầu công việc.<br /> <br /> Đăng ký làm thành viên của chúng tôi, bạn cũng phải đồng ý rằng, bất kỳ thông tin cá nhân nào mà bạn cung cấp đều được lưu trữ trong cơ sở dữ liệu của hệ thống. Mặc dù những thông tin này sẽ không được cung cấp cho bất kỳ người thứ ba nào khác mà không được sự đồng ý của bạn, chúng tôi không chịu trách nhiệm về việc những thông tin cá nhân này của bạn bị lộ ra bên ngoài từ những kẻ phá hoại có ý đồ xấu tấn công vào cơ sở dữ liệu của hệ thống.</p>',	1274757129);

DROP TABLE IF EXISTS `qd_users_edit`;
CREATE TABLE `qd_users_edit` (
  `userid` mediumint(8) unsigned NOT NULL,
  `lastedit` int(11) unsigned NOT NULL DEFAULT 0,
  `info_basic` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `info_custom` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_edit`;

DROP TABLE IF EXISTS `qd_users_field`;
CREATE TABLE `qd_users_field` (
  `fid` mediumint(8) NOT NULL AUTO_INCREMENT,
  `field` varchar(25) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` int(10) unsigned NOT NULL DEFAULT 1,
  `field_type` enum('number','date','textbox','textarea','editor','select','radio','checkbox','multiselect') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'textbox',
  `field_choices` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `sql_choices` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `match_type` enum('none','alphanumeric','email','url','regex','callback') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'none',
  `match_regex` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `func_callback` varchar(75) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `min_length` int(11) NOT NULL DEFAULT 0,
  `max_length` bigint(20) unsigned NOT NULL DEFAULT 0,
  `required` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `show_register` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `user_editable` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `show_profile` tinyint(4) NOT NULL DEFAULT 1,
  `class` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `default_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `is_system` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`fid`),
  UNIQUE KEY `field` (`field`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_field`;
INSERT INTO `qd_users_field` (`fid`, `field`, `weight`, `field_type`, `field_choices`, `sql_choices`, `match_type`, `match_regex`, `func_callback`, `min_length`, `max_length`, `required`, `show_register`, `user_editable`, `show_profile`, `class`, `language`, `default_value`, `is_system`) VALUES
(1,	'first_name',	1,	'textbox',	'',	'',	'none',	'',	'',	0,	100,	1,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:4:\"Tên\";i:1;s:0:\"\";}}',	'',	1),
(2,	'last_name',	2,	'textbox',	'',	'',	'none',	'',	'',	0,	100,	0,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:20:\"Họ và tên đệm\";i:1;s:0:\"\";}}',	'',	1),
(3,	'gender',	3,	'select',	'a:3:{s:1:\"N\";s:0:\"\";s:1:\"M\";s:0:\"\";s:1:\"F\";s:0:\"\";}',	'',	'none',	'',	'',	0,	1,	0,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:12:\"Giới tính\";i:1;s:0:\"\";}}',	'2',	1),
(4,	'birthday',	4,	'date',	'a:1:{s:12:\"current_date\";i:0;}',	'',	'none',	'',	'',	0,	0,	1,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:22:\"Ngày tháng năm sinh\";i:1;s:0:\"\";}}',	'0',	1),
(5,	'sig',	5,	'textarea',	'',	'',	'none',	'',	'',	0,	1000,	0,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:9:\"Chữ ký\";i:1;s:0:\"\";}}',	'',	1),
(6,	'question',	6,	'textbox',	'',	'',	'none',	'',	'',	3,	255,	1,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:22:\"Câu hỏi bảo mật\";i:1;s:0:\"\";}}',	'',	1),
(7,	'answer',	7,	'textbox',	'',	'',	'none',	'',	'',	3,	255,	1,	1,	1,	1,	'input',	'a:1:{s:2:\"vi\";a:2:{i:0;s:22:\"Trả lời câu hỏi\";i:1;s:0:\"\";}}',	'',	1);

DROP TABLE IF EXISTS `qd_users_groups`;
CREATE TABLE `qd_users_groups` (
  `group_id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(240) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `group_type` tinyint(4) unsigned NOT NULL DEFAULT 0 COMMENT '0:Sys, 1:approval, 2:public',
  `group_color` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `group_avatar` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `require_2step_admin` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `require_2step_site` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `is_default` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `add_time` int(11) NOT NULL,
  `exp_time` int(11) NOT NULL,
  `weight` int(11) unsigned NOT NULL DEFAULT 0,
  `act` tinyint(1) unsigned NOT NULL,
  `idsite` int(11) unsigned NOT NULL DEFAULT 0,
  `numbers` mediumint(9) unsigned NOT NULL DEFAULT 0,
  `siteus` tinyint(4) unsigned NOT NULL DEFAULT 0,
  `config` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`group_id`),
  UNIQUE KEY `ktitle` (`title`,`idsite`),
  KEY `exp_time` (`exp_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_groups`;
INSERT INTO `qd_users_groups` (`group_id`, `title`, `email`, `description`, `content`, `group_type`, `group_color`, `group_avatar`, `require_2step_admin`, `require_2step_site`, `is_default`, `add_time`, `exp_time`, `weight`, `act`, `idsite`, `numbers`, `siteus`, `config`) VALUES
(1,	'Super admin',	'',	'Super Admin',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	1,	1,	0,	1,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}'),
(2,	'General admin',	'',	'General Admin',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	2,	1,	0,	0,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}'),
(3,	'Module admin',	'',	'Module Admin',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	3,	1,	0,	0,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}'),
(4,	'Users',	'',	'Users',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	4,	1,	0,	1,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}'),
(7,	'New Users',	'',	'New Users',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	5,	1,	0,	0,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}'),
(5,	'Guest',	'',	'Guest',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	6,	1,	0,	0,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}'),
(6,	'All',	'',	'All',	'',	0,	'',	'',	0,	0,	0,	1596205058,	0,	7,	1,	0,	0,	0,	'a:7:{s:17:\"access_groups_add\";i:1;s:17:\"access_groups_del\";i:1;s:12:\"access_addus\";i:0;s:14:\"access_waiting\";i:0;s:13:\"access_editus\";i:0;s:12:\"access_delus\";i:0;s:13:\"access_passus\";i:0;}');

DROP TABLE IF EXISTS `qd_users_groups_users`;
CREATE TABLE `qd_users_groups_users` (
  `group_id` smallint(5) unsigned NOT NULL DEFAULT 0,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `is_leader` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `approved` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_requested` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'Thời gian yêu cầu tham gia',
  `time_approved` int(11) unsigned NOT NULL DEFAULT 0 COMMENT 'Thời gian duyệt yêu cầu tham gia',
  PRIMARY KEY (`group_id`,`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_groups_users`;
INSERT INTO `qd_users_groups_users` (`group_id`, `userid`, `is_leader`, `approved`, `data`, `time_requested`, `time_approved`) VALUES
(1,	1,	1,	1,	'0',	1596205105,	1596205105);

DROP TABLE IF EXISTS `qd_users_info`;
CREATE TABLE `qd_users_info` (
  `userid` mediumint(8) unsigned NOT NULL,
  PRIMARY KEY (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_info`;
INSERT INTO `qd_users_info` (`userid`) VALUES
(1);

DROP TABLE IF EXISTS `qd_users_openid`;
CREATE TABLE `qd_users_openid` (
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `openid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `opid` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`opid`),
  KEY `userid` (`userid`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_openid`;

DROP TABLE IF EXISTS `qd_users_question`;
CREATE TABLE `qd_users_question` (
  `qid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(240) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `lang` char(2) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `weight` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `add_time` int(11) unsigned NOT NULL DEFAULT 0,
  `edit_time` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`qid`),
  UNIQUE KEY `title` (`title`,`lang`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_question`;
INSERT INTO `qd_users_question` (`qid`, `title`, `lang`, `weight`, `add_time`, `edit_time`) VALUES
(1,	'Bạn thích môn thể thao nào nhất',	'vi',	1,	1274840238,	1274840238),
(2,	'Món ăn mà bạn yêu thích',	'vi',	2,	1274840250,	1274840250),
(3,	'Thần tượng điện ảnh của bạn',	'vi',	3,	1274840257,	1274840257),
(4,	'Bạn thích nhạc sỹ nào nhất',	'vi',	4,	1274840264,	1274840264),
(5,	'Quê ngoại của bạn ở đâu',	'vi',	5,	1274840270,	1274840270),
(6,	'Tên cuốn sách &quot;gối đầu giường&quot;',	'vi',	6,	1274840278,	1274840278),
(7,	'Ngày lễ mà bạn luôn mong đợi',	'vi',	7,	1274840285,	1274840285);

DROP TABLE IF EXISTS `qd_users_reg`;
CREATE TABLE `qd_users_reg` (
  `userid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `md5username` char(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `password` varchar(150) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `gender` char(1) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `birthday` int(11) NOT NULL,
  `sig` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `regdate` int(11) unsigned NOT NULL DEFAULT 0,
  `question` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `checknum` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `users_info` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `openid_info` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `idsite` mediumint(8) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`userid`),
  UNIQUE KEY `login` (`username`),
  UNIQUE KEY `md5username` (`md5username`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_users_reg`;

DROP TABLE IF EXISTS `qd_vi_autoget_news_items_catid`;
CREATE TABLE `qd_vi_autoget_news_items_catid` (
  `itemid` mediumint(8) unsigned NOT NULL,
  `catid` smallint(4) unsigned NOT NULL,
  UNIQUE KEY `itemid` (`itemid`,`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_autoget_news_items_catid`;
INSERT INTO `qd_vi_autoget_news_items_catid` (`itemid`, `catid`) VALUES
(1,	20);

DROP TABLE IF EXISTS `qd_vi_blocks_groups`;
CREATE TABLE `qd_vi_blocks_groups` (
  `bid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `theme` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `file_name` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` varchar(55) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `exp_time` int(11) DEFAULT 0,
  `active` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT '1',
  `act` tinyint(1) unsigned NOT NULL DEFAULT 1,
  `groups_view` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `all_func` tinyint(4) NOT NULL DEFAULT 0,
  `weight` int(11) NOT NULL DEFAULT 0,
  `config` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`bid`),
  KEY `theme` (`theme`),
  KEY `module` (`module`),
  KEY `position` (`position`),
  KEY `exp_time` (`exp_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blocks_groups`;
INSERT INTO `qd_vi_blocks_groups` (`bid`, `theme`, `module`, `file_name`, `title`, `link`, `template`, `position`, `exp_time`, `active`, `act`, `groups_view`, `all_func`, `weight`, `config`) VALUES
(46,	'huynhquocdat',	'newsnotice',	'global.newsnotice_reg_email.php',	'Đăng ký nhận tin từ Email',	'',	'no_title',	'[FOOTER_SITE]',	0,	'1',	1,	'6',	1,	1,	'a:1:{s:4:\"text\";s:0:\"\";}'),
(2,	'default',	'banners',	'global.banners.php',	'Quảng cáo giữa trang',	'',	'no_title',	'[TOP]',	0,	'1',	1,	'6',	0,	2,	'a:1:{s:12:\"idplanbanner\";i:1;}'),
(4,	'default',	'theme',	'global.module_menu.php',	'Module Menu',	'',	'no_title',	'[LEFT]',	0,	'1',	1,	'6',	0,	2,	''),
(5,	'default',	'banners',	'global.banners.php',	'Quảng cáo cột trái',	'',	'no_title',	'[LEFT]',	0,	'1',	1,	'6',	1,	3,	'a:1:{s:12:\"idplanbanner\";i:2;}'),
(6,	'default',	'statistics',	'global.counter.php',	'Thống kê',	'',	'primary',	'[LEFT]',	0,	'1',	1,	'6',	1,	4,	''),
(31,	'huynhquocdat',	'theme',	'global.company_info.php',	'Công ty chủ quản',	'',	'simple',	'[COMPANY_INFO]',	0,	'1',	1,	'6',	1,	1,	'a:13:{s:12:\"company_name\";s:58:\"Công ty cổ phần phát triển nguồn mở Việt Nam\";s:16:\"company_sortname\";s:12:\"VINADES.,JSC\";s:15:\"company_regcode\";s:0:\"\";s:16:\"company_regplace\";s:0:\"\";s:21:\"company_licensenumber\";s:0:\"\";s:22:\"company_responsibility\";s:0:\"\";s:15:\"company_address\";s:72:\"Phòng 1706 - Tòa nhà CT2 Nàng Hương, 583 Nguyễn Trãi, Hà Nội\";s:15:\"company_showmap\";i:1;s:14:\"company_mapurl\";s:326:\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2634.116366996857!2d105.79399620326203!3d20.9844946314258!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3135ac93055e2f2f%3A0x91f4b423089193dd!2zQ8O0bmcgdHkgQ-G7lSBwaOG6p24gUGjDoXQgdHJp4buDbiBOZ3Xhu5NuIG3hu58gVmnhu4d0IE5hbQ!5e0!3m2!1svi!2s!4v1558315703646!5m2!1svi!2s\";s:13:\"company_phone\";s:74:\"+84-24-85872007&#91;+842485872007&#93;|+84-904762534&#91;+84904762534&#93;\";s:11:\"company_fax\";s:15:\"+84-24-35500914\";s:13:\"company_email\";s:18:\"contact@vinades.vn\";s:15:\"company_website\";s:17:\"http://vinades.vn\";}'),
(8,	'default',	'banners',	'global.banners.php',	'Quảng cáo cột phải',	'',	'no_title',	'[RIGHT]',	0,	'1',	1,	'6',	1,	2,	'a:1:{s:12:\"idplanbanner\";i:3;}'),
(9,	'default',	'voting',	'global.voting_random.php',	'Thăm dò ý kiến',	'',	'primary',	'[RIGHT]',	0,	'1',	1,	'6',	1,	3,	''),
(11,	'default',	'theme',	'global.copyright.php',	'Copyright',	'',	'no_title',	'[FOOTER_SITE]',	0,	'1',	1,	'6',	1,	1,	'a:5:{s:12:\"copyright_by\";s:0:\"\";s:13:\"copyright_url\";s:0:\"\";s:9:\"design_by\";s:12:\"VINADES.,JSC\";s:10:\"design_url\";s:18:\"http://vinades.vn/\";s:13:\"siteterms_url\";s:46:\"/dmnuke/index.php?language=vi&amp;nv=siteterms\";}'),
(13,	'default',	'theme',	'global.QR_code.php',	'QR code',	'',	'no_title',	'[QR_CODE]',	0,	'1',	1,	'6',	1,	1,	'a:3:{s:5:\"level\";s:1:\"M\";s:15:\"pixel_per_point\";i:4;s:11:\"outer_frame\";i:1;}'),
(14,	'default',	'statistics',	'global.counter_button.php',	'Online button',	'',	'no_title',	'[QR_CODE]',	0,	'1',	1,	'6',	1,	2,	''),
(15,	'default',	'users',	'global.user_button.php',	'Đăng nhập thành viên',	'',	'no_title',	'[PERSONALAREA]',	0,	'1',	1,	'6',	1,	1,	''),
(16,	'default',	'theme',	'global.company_info.php',	'Công ty chủ quản',	'',	'simple',	'[COMPANY_INFO]',	0,	'1',	1,	'6',	1,	1,	'a:13:{s:12:\"company_name\";s:58:\"Công ty cổ phần phát triển nguồn mở Việt Nam\";s:15:\"company_address\";s:72:\"Phòng 1706 - Tòa nhà CT2 Nàng Hương, 583 Nguyễn Trãi, Hà Nội\";s:16:\"company_sortname\";s:12:\"VINADES.,JSC\";s:15:\"company_regcode\";s:0:\"\";s:16:\"company_regplace\";s:0:\"\";s:21:\"company_licensenumber\";s:0:\"\";s:22:\"company_responsibility\";s:0:\"\";s:15:\"company_showmap\";i:1;s:14:\"company_mapurl\";s:326:\"https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d2634.116366996857!2d105.79399620326203!3d20.9844946314258!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x3135ac93055e2f2f%3A0x91f4b423089193dd!2zQ8O0bmcgdHkgQ-G7lSBwaOG6p24gUGjDoXQgdHJp4buDbiBOZ3Xhu5NuIG3hu58gVmnhu4d0IE5hbQ!5e0!3m2!1svi!2s!4v1558315703646!5m2!1svi!2s\";s:13:\"company_phone\";s:58:\"+84-24-85872007[+842485872007]|+84-904762534[+84904762534]\";s:11:\"company_fax\";s:15:\"+84-24-35500914\";s:13:\"company_email\";s:18:\"contact@vinades.vn\";s:15:\"company_website\";s:17:\"http://vinades.vn\";}'),
(17,	'default',	'menu',	'global.bootstrap.php',	'Menu Site',	'',	'no_title',	'[MENU_SITE]',	0,	'1',	1,	'6',	1,	1,	'a:2:{s:6:\"menuid\";i:1;s:12:\"title_length\";i:0;}'),
(19,	'default',	'theme',	'global.social.php',	'Social icon',	'',	'no_title',	'[SOCIAL_ICONS]',	0,	'1',	1,	'6',	1,	1,	'a:3:{s:8:\"facebook\";s:32:\"http://www.facebook.com/nukeviet\";s:7:\"youtube\";s:37:\"https://www.youtube.com/user/nukeviet\";s:7:\"twitter\";s:28:\"https://twitter.com/nukeviet\";}'),
(20,	'default',	'theme',	'global.menu_footer.php',	'Các chuyên mục chính',	'',	'simple',	'[MENU_FOOTER]',	0,	'1',	1,	'6',	1,	1,	'a:1:{s:14:\"module_in_menu\";a:8:{i:0;s:5:\"about\";i:1;s:4:\"news\";i:2;s:5:\"users\";i:3;s:7:\"contact\";i:4;s:6:\"voting\";i:5;s:7:\"banners\";i:6;s:4:\"seek\";i:7;s:5:\"feeds\";}}'),
(33,	'huynhquocdat',	'theme',	'global.module_menu.php',	'Module Menu',	'',	'no_title',	'[LEFT]',	0,	'1',	1,	'6',	0,	1,	''),
(34,	'huynhquocdat',	'banners',	'global.banners.php',	'Quảng cáo cột trái',	'',	'no_title',	'[LEFT]',	0,	'1',	1,	'6',	1,	2,	'a:1:{s:12:\"idplanbanner\";i:2;}'),
(35,	'huynhquocdat',	'statistics',	'global.counter.php',	'Thống kê',	'',	'primary',	'[LEFT]',	0,	'1',	1,	'6',	1,	3,	''),
(36,	'huynhquocdat',	'theme',	'global.menu_footer.php',	'Các chuyên mục chính',	'',	'simple',	'[MENU_FOOTER]',	0,	'1',	1,	'6',	1,	1,	'a:1:{s:14:\"module_in_menu\";a:8:{i:0;s:5:\"about\";i:1;s:4:\"news\";i:2;s:5:\"users\";i:3;s:7:\"contact\";i:4;s:6:\"voting\";i:5;s:7:\"banners\";i:6;s:4:\"seek\";i:7;s:5:\"feeds\";}}'),
(37,	'huynhquocdat',	'menu',	'global.bootstrap.php',	'Menu Site',	'',	'no_title',	'[MENU_SITE]',	0,	'1',	1,	'6',	1,	1,	'a:2:{s:6:\"menuid\";i:1;s:12:\"title_length\";i:0;}'),
(38,	'huynhquocdat',	'menu',	'global.top_header.php',	'Menu top header',	'',	'no_title',	'[PERSONALAREA]',	0,	'1',	1,	'6',	1,	1,	'a:2:{s:6:\"menuid\";i:2;s:12:\"title_length\";i:0;}'),
(39,	'huynhquocdat',	'theme',	'global.QR_code.php',	'QR code',	'',	'no_title',	'[QR_CODE]',	0,	'1',	1,	'6',	1,	1,	'a:3:{s:5:\"level\";s:1:\"M\";s:15:\"pixel_per_point\";i:4;s:11:\"outer_frame\";i:1;}'),
(40,	'huynhquocdat',	'statistics',	'global.counter_button.php',	'Online button',	'',	'no_title',	'[QR_CODE]',	0,	'1',	1,	'6',	1,	2,	''),
(43,	'huynhquocdat',	'theme',	'global.social.php',	'Social icon',	'',	'no_title',	'[SOCIAL_ICONS]',	0,	'1',	1,	'6',	1,	1,	'a:4:{s:8:\"facebook\";s:32:\"http://www.facebook.com/nukeviet\";s:11:\"google_plus\";s:32:\"https://www.google.com/+nukeviet\";s:7:\"youtube\";s:37:\"https://www.youtube.com/user/nukeviet\";s:7:\"twitter\";s:28:\"https://twitter.com/nukeviet\";}'),
(44,	'huynhquocdat',	'banners',	'global.banners.php',	'Quảng cáo giữa trang',	'',	'no_title',	'[TOP]',	0,	'1',	1,	'6',	0,	1,	'a:1:{s:12:\"idplanbanner\";i:1;}'),
(45,	'huynhquocdat',	'blog',	'module.block_news.php',	'TOP BLOG HOME SLIDER',	'',	'no_title',	'[HEADER]',	0,	'1',	0,	'6',	0,	1,	'a:4:{s:6:\"numrow\";i:3;s:11:\"showtooltip\";i:0;s:16:\"tooltip_position\";s:6:\"bottom\";s:14:\"tooltip_length\";s:1:\"0\";}');

DROP TABLE IF EXISTS `qd_vi_blocks_weight`;
CREATE TABLE `qd_vi_blocks_weight` (
  `bid` mediumint(8) NOT NULL DEFAULT 0,
  `func_id` mediumint(8) NOT NULL DEFAULT 0,
  `weight` mediumint(8) NOT NULL DEFAULT 0,
  UNIQUE KEY `bid` (`bid`,`func_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blocks_weight`;
INSERT INTO `qd_vi_blocks_weight` (`bid`, `func_id`, `weight`) VALUES
(16,	1,	1),
(16,	38,	1),
(16,	39,	1),
(16,	40,	1),
(16,	41,	1),
(16,	47,	1),
(16,	48,	1),
(16,	49,	1),
(16,	50,	1),
(16,	51,	1),
(16,	61,	1),
(16,	64,	1),
(16,	4,	1),
(16,	5,	1),
(16,	6,	1),
(16,	7,	1),
(16,	8,	1),
(16,	9,	1),
(16,	10,	1),
(16,	11,	1),
(16,	12,	1),
(16,	52,	1),
(16,	63,	1),
(16,	55,	1),
(16,	56,	1),
(16,	31,	1),
(16,	32,	1),
(16,	33,	1),
(16,	34,	1),
(16,	35,	1),
(16,	36,	1),
(16,	37,	1),
(16,	58,	1),
(16,	59,	1),
(16,	60,	1),
(16,	19,	1),
(16,	20,	1),
(16,	21,	1),
(16,	22,	1),
(16,	23,	1),
(16,	24,	1),
(16,	25,	1),
(16,	26,	1),
(16,	27,	1),
(16,	28,	1),
(16,	29,	1),
(16,	62,	1),
(36,	23,	1),
(36,	22,	1),
(36,	21,	1),
(36,	20,	1),
(36,	19,	1),
(36,	60,	1),
(36,	59,	1),
(36,	58,	1),
(36,	37,	1),
(36,	36,	1),
(36,	35,	1),
(36,	34,	1),
(36,	33,	1),
(36,	32,	1),
(36,	31,	1),
(36,	63,	1),
(36,	52,	1),
(36,	64,	1),
(36,	51,	1),
(36,	50,	1),
(36,	49,	1),
(36,	48,	1),
(36,	47,	1),
(36,	103,	1),
(36,	108,	1),
(36,	96,	1),
(36,	105,	1),
(36,	97,	1),
(36,	98,	1),
(36,	109,	1),
(36,	110,	1),
(36,	100,	1),
(36,	41,	1),
(36,	40,	1),
(36,	39,	1),
(36,	38,	1),
(35,	62,	2),
(35,	29,	2),
(35,	28,	3),
(35,	27,	3),
(35,	26,	3),
(35,	25,	3),
(35,	24,	3),
(35,	23,	3),
(35,	22,	3),
(35,	21,	3),
(35,	20,	3),
(13,	109,	1),
(13,	110,	1),
(13,	100,	1),
(15,	103,	1),
(15,	108,	1),
(15,	96,	1),
(15,	105,	1),
(15,	97,	1),
(15,	98,	1),
(15,	109,	1),
(15,	110,	1),
(15,	100,	1),
(17,	103,	1),
(17,	108,	1),
(17,	96,	1),
(17,	105,	1),
(17,	97,	1),
(17,	98,	1),
(17,	109,	1),
(17,	110,	1),
(17,	100,	1),
(20,	103,	1),
(20,	108,	1),
(20,	96,	1),
(20,	105,	1),
(20,	97,	1),
(20,	98,	1),
(20,	109,	1),
(20,	110,	1),
(20,	100,	1),
(6,	103,	2),
(6,	108,	2),
(6,	96,	2),
(6,	105,	2),
(6,	97,	2),
(6,	98,	2),
(6,	109,	2),
(6,	110,	2),
(6,	100,	2),
(5,	103,	1),
(5,	108,	1),
(5,	96,	1),
(5,	105,	1),
(5,	97,	1),
(5,	98,	1),
(5,	109,	1),
(5,	110,	1),
(11,	1,	1),
(11,	38,	1),
(11,	39,	1),
(11,	40,	1),
(11,	41,	1),
(11,	47,	1),
(11,	48,	1),
(11,	49,	1),
(11,	50,	1),
(11,	51,	1),
(11,	61,	1),
(11,	64,	1),
(11,	4,	1),
(11,	5,	1),
(11,	6,	1),
(11,	7,	1),
(11,	8,	1),
(11,	9,	1),
(11,	10,	1),
(11,	11,	1),
(11,	12,	1),
(11,	52,	1),
(11,	63,	1),
(11,	55,	1),
(11,	56,	1),
(11,	31,	1),
(11,	32,	1),
(11,	33,	1),
(11,	34,	1),
(11,	35,	1),
(11,	36,	1),
(11,	37,	1),
(11,	58,	1),
(11,	59,	1),
(11,	60,	1),
(11,	19,	1),
(11,	20,	1),
(11,	21,	1),
(11,	22,	1),
(11,	23,	1),
(11,	24,	1),
(11,	25,	1),
(11,	26,	1),
(11,	27,	1),
(11,	28,	1),
(11,	29,	1),
(11,	62,	1),
(35,	19,	3),
(35,	60,	2),
(35,	59,	2),
(35,	58,	2),
(35,	37,	3),
(35,	36,	3),
(35,	35,	3),
(35,	34,	3),
(35,	33,	3),
(35,	32,	3),
(35,	31,	3),
(35,	63,	2),
(35,	52,	2),
(35,	64,	2),
(35,	51,	2),
(35,	50,	2),
(35,	49,	2),
(35,	48,	2),
(35,	47,	2),
(35,	103,	2),
(35,	108,	2),
(35,	96,	2),
(35,	105,	2),
(35,	97,	2),
(35,	98,	2),
(35,	109,	2),
(35,	110,	2),
(35,	100,	2),
(35,	41,	2),
(35,	40,	2),
(35,	39,	2),
(35,	38,	2),
(34,	62,	1),
(34,	29,	1),
(34,	28,	2),
(34,	27,	2),
(34,	26,	2),
(34,	25,	2),
(34,	24,	2),
(34,	23,	2),
(34,	22,	2),
(34,	21,	2),
(34,	20,	2),
(34,	19,	2),
(34,	60,	1),
(34,	59,	1),
(34,	58,	1),
(38,	35,	1),
(38,	34,	1),
(38,	33,	1),
(38,	32,	1),
(38,	31,	1),
(38,	63,	1),
(38,	52,	1),
(38,	64,	1),
(38,	51,	1),
(4,	19,	1),
(4,	20,	1),
(4,	21,	1),
(4,	22,	1),
(4,	23,	1),
(4,	24,	1),
(4,	25,	1),
(4,	26,	1),
(4,	27,	1),
(4,	28,	1),
(4,	31,	1),
(4,	32,	1),
(4,	33,	1),
(4,	34,	1),
(4,	35,	1),
(4,	36,	1),
(4,	37,	1),
(5,	1,	1),
(5,	38,	1),
(5,	39,	1),
(5,	40,	1),
(5,	41,	1),
(5,	47,	1),
(5,	48,	1),
(5,	49,	1),
(5,	50,	1),
(5,	51,	1),
(5,	61,	1),
(5,	64,	1),
(5,	4,	2),
(5,	5,	2),
(5,	6,	2),
(5,	7,	2),
(5,	8,	2),
(5,	9,	2),
(5,	10,	2),
(5,	11,	2),
(5,	12,	2),
(5,	52,	1),
(5,	63,	1),
(5,	55,	1),
(5,	56,	1),
(5,	31,	2),
(5,	32,	2),
(5,	33,	2),
(5,	34,	2),
(5,	35,	2),
(5,	36,	2),
(5,	37,	2),
(5,	58,	1),
(5,	59,	1),
(5,	60,	1),
(5,	19,	2),
(5,	20,	2),
(5,	21,	2),
(5,	22,	2),
(5,	23,	2),
(5,	24,	2),
(5,	25,	2),
(5,	26,	2),
(5,	27,	2),
(5,	28,	2),
(5,	29,	1),
(5,	62,	1),
(6,	1,	2),
(6,	38,	2),
(6,	39,	2),
(6,	40,	2),
(6,	41,	2),
(6,	47,	2),
(6,	48,	2),
(6,	49,	2),
(6,	50,	2),
(6,	51,	2),
(6,	61,	2),
(6,	64,	2),
(6,	4,	3),
(6,	5,	3),
(6,	6,	3),
(6,	7,	3),
(6,	8,	3),
(6,	9,	3),
(6,	10,	3),
(6,	11,	3),
(6,	12,	3),
(6,	52,	2),
(6,	63,	2),
(6,	55,	2),
(6,	56,	2),
(6,	31,	3),
(6,	32,	3),
(6,	33,	3),
(6,	34,	3),
(6,	35,	3),
(6,	36,	3),
(6,	37,	3),
(6,	58,	2),
(6,	59,	2),
(6,	60,	2),
(6,	19,	3),
(6,	20,	3),
(6,	21,	3),
(6,	22,	3),
(6,	23,	3),
(6,	24,	3),
(6,	25,	3),
(6,	26,	3),
(6,	27,	3),
(6,	28,	3),
(6,	29,	2),
(6,	62,	2),
(20,	1,	1),
(20,	38,	1),
(20,	39,	1),
(20,	40,	1),
(20,	41,	1),
(20,	47,	1),
(20,	48,	1),
(20,	49,	1),
(20,	50,	1),
(20,	51,	1),
(20,	61,	1),
(20,	64,	1),
(20,	4,	1),
(20,	5,	1),
(20,	6,	1),
(20,	7,	1),
(20,	8,	1),
(20,	9,	1),
(20,	10,	1),
(20,	11,	1),
(20,	12,	1),
(20,	52,	1),
(20,	63,	1),
(20,	55,	1),
(20,	56,	1),
(20,	31,	1),
(20,	32,	1),
(20,	33,	1),
(20,	34,	1),
(20,	35,	1),
(20,	36,	1),
(20,	37,	1),
(20,	58,	1),
(20,	59,	1),
(20,	60,	1),
(20,	19,	1),
(20,	20,	1),
(20,	21,	1),
(20,	22,	1),
(20,	23,	1),
(20,	24,	1),
(20,	25,	1),
(20,	26,	1),
(20,	27,	1),
(20,	28,	1),
(20,	29,	1),
(20,	62,	1),
(17,	1,	1),
(17,	38,	1),
(17,	39,	1),
(17,	40,	1),
(17,	41,	1),
(17,	47,	1),
(17,	48,	1),
(17,	49,	1),
(17,	50,	1),
(17,	51,	1),
(17,	61,	1),
(17,	64,	1),
(17,	4,	1),
(17,	5,	1),
(17,	6,	1),
(17,	7,	1),
(17,	8,	1),
(17,	9,	1),
(17,	10,	1),
(17,	11,	1),
(17,	12,	1),
(17,	52,	1),
(17,	63,	1),
(17,	55,	1),
(17,	56,	1),
(17,	31,	1),
(17,	32,	1),
(17,	33,	1),
(17,	34,	1),
(17,	35,	1),
(17,	36,	1),
(17,	37,	1),
(17,	58,	1),
(17,	59,	1),
(17,	60,	1),
(17,	19,	1),
(17,	20,	1),
(17,	21,	1),
(17,	22,	1),
(17,	23,	1),
(17,	24,	1),
(17,	25,	1),
(17,	26,	1),
(17,	27,	1),
(17,	28,	1),
(17,	29,	1),
(17,	62,	1),
(15,	1,	1),
(15,	38,	1),
(15,	39,	1),
(15,	40,	1),
(15,	41,	1),
(15,	47,	1),
(15,	48,	1),
(15,	49,	1),
(15,	50,	1),
(15,	51,	1),
(15,	61,	1),
(15,	64,	1),
(15,	4,	1),
(15,	5,	1),
(15,	6,	1),
(15,	7,	1),
(15,	8,	1),
(15,	9,	1),
(15,	10,	1),
(15,	11,	1),
(15,	12,	1),
(15,	52,	1),
(15,	63,	1),
(15,	55,	1),
(15,	56,	1),
(15,	31,	1),
(15,	32,	1),
(15,	33,	1),
(15,	34,	1),
(15,	35,	1),
(15,	36,	1),
(15,	37,	1),
(15,	58,	1),
(15,	59,	1),
(15,	60,	1),
(15,	19,	1),
(15,	20,	1),
(15,	21,	1),
(15,	22,	1),
(15,	23,	1),
(15,	24,	1),
(15,	25,	1),
(15,	26,	1),
(15,	27,	1),
(15,	28,	1),
(15,	29,	1),
(15,	62,	1),
(13,	1,	1),
(13,	38,	1),
(13,	39,	1),
(13,	40,	1),
(13,	41,	1),
(13,	47,	1),
(13,	48,	1),
(13,	49,	1),
(13,	50,	1),
(13,	51,	1),
(13,	61,	1),
(13,	64,	1),
(13,	4,	1),
(13,	5,	1),
(13,	6,	1),
(13,	7,	1),
(13,	8,	1),
(13,	9,	1),
(13,	10,	1),
(13,	11,	1),
(13,	12,	1),
(13,	52,	1),
(13,	63,	1),
(13,	55,	1),
(13,	56,	1),
(13,	31,	1),
(13,	32,	1),
(13,	33,	1),
(13,	34,	1),
(13,	35,	1),
(13,	36,	1),
(13,	37,	1),
(13,	58,	1),
(13,	59,	1),
(13,	60,	1),
(13,	19,	1),
(13,	20,	1),
(13,	21,	1),
(13,	22,	1),
(13,	23,	1),
(13,	24,	1),
(13,	25,	1),
(13,	26,	1),
(13,	27,	1),
(13,	28,	1),
(13,	29,	1),
(13,	62,	1),
(14,	1,	2),
(14,	38,	2),
(14,	39,	2),
(14,	40,	2),
(14,	41,	2),
(14,	47,	2),
(14,	48,	2),
(14,	49,	2),
(14,	50,	2),
(14,	51,	2),
(14,	61,	2),
(14,	64,	2),
(14,	4,	2),
(14,	5,	2),
(14,	6,	2),
(14,	7,	2),
(14,	8,	2),
(14,	9,	2),
(14,	10,	2),
(14,	11,	2),
(14,	12,	2),
(14,	52,	2),
(14,	63,	2),
(14,	55,	2),
(14,	56,	2),
(14,	31,	2),
(14,	32,	2),
(14,	33,	2),
(14,	34,	2),
(14,	35,	2),
(14,	36,	2),
(14,	37,	2),
(14,	58,	2),
(14,	59,	2),
(14,	60,	2),
(14,	19,	2),
(14,	20,	2),
(14,	21,	2),
(14,	22,	2),
(14,	23,	2),
(14,	24,	2),
(14,	25,	2),
(14,	26,	2),
(14,	27,	2),
(14,	28,	2),
(14,	29,	2),
(14,	62,	2),
(43,	115,	1),
(43,	116,	1),
(40,	115,	2),
(40,	116,	2),
(39,	115,	1),
(39,	116,	1),
(38,	115,	1),
(38,	116,	1),
(37,	115,	1),
(37,	116,	1),
(36,	115,	1),
(36,	116,	1),
(35,	115,	2),
(35,	116,	2),
(34,	115,	1),
(34,	116,	1),
(31,	115,	1),
(31,	116,	1),
(19,	115,	1),
(19,	116,	1),
(9,	115,	2),
(9,	116,	2),
(8,	115,	1),
(8,	116,	1),
(14,	115,	2),
(14,	116,	2),
(13,	115,	1),
(31,	62,	1),
(31,	29,	1),
(31,	28,	1),
(31,	27,	1),
(31,	26,	1),
(31,	25,	1),
(31,	24,	1),
(31,	23,	1),
(31,	22,	1),
(31,	21,	1),
(31,	20,	1),
(31,	19,	1),
(31,	60,	1),
(31,	59,	1),
(31,	58,	1),
(8,	1,	2),
(8,	38,	2),
(8,	39,	2),
(8,	40,	2),
(8,	41,	2),
(8,	47,	2),
(8,	48,	2),
(8,	49,	2),
(8,	50,	2),
(8,	51,	2),
(8,	61,	2),
(8,	64,	2),
(8,	4,	2),
(8,	5,	2),
(8,	6,	2),
(8,	7,	2),
(8,	8,	2),
(8,	9,	2),
(8,	10,	2),
(8,	11,	2),
(8,	12,	2),
(8,	52,	2),
(8,	63,	2),
(8,	55,	2),
(8,	56,	2),
(8,	31,	2),
(8,	32,	2),
(8,	33,	2),
(8,	34,	2),
(8,	35,	2),
(8,	36,	2),
(8,	37,	2),
(8,	58,	2),
(8,	59,	2),
(8,	60,	2),
(8,	19,	2),
(8,	20,	2),
(8,	21,	2),
(8,	22,	2),
(8,	23,	2),
(8,	24,	2),
(8,	25,	2),
(8,	26,	2),
(8,	27,	2),
(8,	28,	2),
(8,	29,	2),
(8,	62,	2),
(9,	1,	3),
(9,	38,	3),
(9,	39,	3),
(9,	40,	3),
(9,	41,	3),
(9,	47,	3),
(9,	48,	3),
(9,	49,	3),
(9,	50,	3),
(9,	51,	3),
(9,	61,	3),
(9,	64,	3),
(9,	4,	3),
(9,	5,	3),
(9,	6,	3),
(9,	7,	3),
(9,	8,	3),
(9,	9,	3),
(9,	10,	3),
(9,	11,	3),
(9,	12,	3),
(9,	52,	3),
(9,	63,	3),
(9,	55,	3),
(9,	56,	3),
(9,	31,	3),
(9,	32,	3),
(9,	33,	3),
(9,	34,	3),
(9,	35,	3),
(9,	36,	3),
(9,	37,	3),
(9,	58,	3),
(9,	59,	3),
(9,	60,	3),
(9,	19,	3),
(9,	20,	3),
(9,	21,	3),
(9,	22,	3),
(9,	23,	3),
(9,	24,	3),
(9,	25,	3),
(9,	26,	3),
(9,	27,	3),
(9,	28,	3),
(9,	29,	3),
(9,	62,	3),
(38,	50,	1),
(38,	49,	1),
(38,	48,	1),
(38,	47,	1),
(38,	103,	1),
(38,	108,	1),
(38,	96,	1),
(38,	105,	1),
(38,	97,	1),
(38,	98,	1),
(38,	109,	1),
(38,	110,	1),
(38,	100,	1),
(38,	41,	1),
(38,	40,	1),
(38,	39,	1),
(38,	38,	1),
(37,	62,	1),
(37,	29,	1),
(37,	28,	1),
(37,	27,	1),
(37,	26,	1),
(37,	25,	1),
(37,	24,	1),
(37,	23,	1),
(37,	22,	1),
(37,	21,	1),
(37,	20,	1),
(37,	19,	1),
(37,	60,	1),
(37,	59,	1),
(37,	58,	1),
(37,	37,	1),
(37,	36,	1),
(37,	35,	1),
(37,	34,	1),
(37,	33,	1),
(37,	32,	1),
(37,	31,	1),
(37,	63,	1),
(37,	52,	1),
(37,	64,	1),
(37,	51,	1),
(37,	50,	1),
(37,	49,	1),
(37,	48,	1),
(37,	47,	1),
(19,	1,	1),
(19,	38,	1),
(19,	39,	1),
(19,	40,	1),
(19,	41,	1),
(19,	47,	1),
(19,	48,	1),
(19,	49,	1),
(19,	50,	1),
(19,	51,	1),
(19,	61,	1),
(19,	64,	1),
(19,	4,	1),
(19,	5,	1),
(19,	6,	1),
(19,	7,	1),
(19,	8,	1),
(19,	9,	1),
(19,	10,	1),
(19,	11,	1),
(19,	12,	1),
(19,	52,	1),
(19,	63,	1),
(19,	55,	1),
(19,	56,	1),
(19,	31,	1),
(19,	32,	1),
(19,	33,	1),
(19,	34,	1),
(19,	35,	1),
(19,	36,	1),
(19,	37,	1),
(19,	58,	1),
(19,	59,	1),
(19,	60,	1),
(19,	19,	1),
(19,	20,	1),
(19,	21,	1),
(19,	22,	1),
(19,	23,	1),
(19,	24,	1),
(19,	25,	1),
(19,	26,	1),
(19,	27,	1),
(19,	28,	1),
(19,	29,	1),
(19,	62,	1),
(37,	103,	1),
(2,	4,	2),
(34,	37,	2),
(34,	36,	2),
(34,	35,	2),
(34,	34,	2),
(34,	33,	2),
(34,	32,	2),
(34,	31,	2),
(34,	63,	1),
(34,	52,	1),
(34,	64,	1),
(34,	51,	1),
(34,	50,	1),
(34,	49,	1),
(34,	48,	1),
(34,	47,	1),
(34,	103,	1),
(34,	108,	1),
(34,	96,	1),
(34,	105,	1),
(34,	97,	1),
(34,	98,	1),
(34,	109,	1),
(34,	110,	1),
(34,	100,	1),
(34,	41,	1),
(34,	40,	1),
(34,	39,	1),
(34,	38,	1),
(33,	37,	1),
(33,	36,	1),
(33,	35,	1),
(33,	34,	1),
(33,	33,	1),
(33,	32,	1),
(33,	31,	1),
(33,	28,	1),
(33,	27,	1),
(33,	26,	1),
(33,	25,	1),
(33,	24,	1),
(33,	23,	1),
(33,	22,	1),
(33,	21,	1),
(33,	20,	1),
(33,	19,	1),
(13,	116,	1),
(15,	115,	1),
(15,	116,	1),
(17,	115,	1),
(17,	116,	1),
(20,	115,	1),
(20,	116,	1),
(6,	115,	2),
(6,	116,	2),
(5,	115,	1),
(5,	116,	1),
(16,	65,	1),
(5,	100,	1),
(11,	65,	1),
(5,	65,	1),
(6,	65,	2),
(20,	65,	1),
(17,	65,	1),
(15,	65,	1),
(13,	65,	1),
(14,	65,	2),
(31,	37,	1),
(8,	65,	2),
(9,	65,	3),
(37,	108,	1),
(19,	65,	1),
(16,	77,	1),
(16,	93,	1),
(16,	72,	1),
(16,	86,	1),
(16,	67,	1),
(16,	78,	1),
(16,	79,	1),
(16,	70,	1),
(16,	75,	1),
(16,	74,	1),
(16,	87,	1),
(16,	69,	1),
(16,	94,	1),
(16,	92,	1),
(16,	80,	1),
(16,	90,	1),
(16,	73,	1),
(16,	66,	1),
(11,	103,	1),
(11,	108,	1),
(11,	96,	1),
(11,	105,	1),
(11,	97,	1),
(11,	98,	1),
(11,	109,	1),
(11,	110,	1),
(11,	100,	1),
(16,	103,	1),
(16,	108,	1),
(16,	96,	1),
(16,	105,	1),
(16,	97,	1),
(16,	98,	1),
(16,	109,	1),
(16,	110,	1),
(16,	100,	1),
(11,	77,	1),
(11,	93,	1),
(11,	72,	1),
(11,	86,	1),
(11,	67,	1),
(11,	78,	1),
(11,	79,	1),
(11,	70,	1),
(11,	75,	1),
(11,	74,	1),
(11,	87,	1),
(11,	69,	1),
(11,	94,	1),
(11,	92,	1),
(11,	80,	1),
(11,	90,	1),
(11,	73,	1),
(11,	66,	1),
(19,	103,	1),
(19,	108,	1),
(19,	96,	1),
(19,	105,	1),
(19,	97,	1),
(19,	98,	1),
(19,	109,	1),
(19,	110,	1),
(19,	100,	1),
(9,	103,	3),
(9,	108,	3),
(9,	96,	3),
(9,	105,	3),
(9,	97,	3),
(9,	98,	3),
(5,	77,	1),
(5,	93,	1),
(5,	72,	1),
(5,	86,	1),
(5,	67,	1),
(5,	78,	1),
(5,	79,	1),
(5,	70,	1),
(5,	75,	1),
(5,	74,	1),
(5,	87,	1),
(5,	69,	1),
(5,	94,	1),
(5,	92,	1),
(5,	80,	1),
(5,	90,	1),
(5,	73,	1),
(5,	66,	1),
(6,	77,	2),
(6,	93,	2),
(6,	72,	2),
(6,	86,	2),
(6,	67,	2),
(6,	78,	2),
(6,	79,	2),
(6,	70,	2),
(6,	75,	2),
(6,	74,	2),
(6,	87,	2),
(6,	69,	2),
(6,	94,	2),
(6,	92,	2),
(6,	80,	2),
(6,	90,	2),
(6,	73,	2),
(6,	66,	2),
(20,	77,	1),
(20,	93,	1),
(20,	72,	1),
(20,	86,	1),
(20,	67,	1),
(20,	78,	1),
(20,	79,	1),
(20,	70,	1),
(20,	75,	1),
(20,	74,	1),
(20,	87,	1),
(20,	69,	1),
(20,	94,	1),
(20,	92,	1),
(20,	80,	1),
(20,	90,	1),
(20,	73,	1),
(20,	66,	1),
(17,	77,	1),
(17,	93,	1),
(17,	72,	1),
(17,	86,	1),
(17,	67,	1),
(17,	78,	1),
(17,	79,	1),
(17,	70,	1),
(17,	75,	1),
(17,	74,	1),
(17,	87,	1),
(17,	69,	1),
(17,	94,	1),
(17,	92,	1),
(17,	80,	1),
(17,	90,	1),
(17,	73,	1),
(17,	66,	1),
(15,	77,	1),
(15,	93,	1),
(15,	72,	1),
(15,	86,	1),
(15,	67,	1),
(15,	78,	1),
(15,	79,	1),
(15,	70,	1),
(15,	75,	1),
(15,	74,	1),
(15,	87,	1),
(15,	69,	1),
(15,	94,	1),
(15,	92,	1),
(15,	80,	1),
(15,	90,	1),
(15,	73,	1),
(15,	66,	1),
(13,	77,	1),
(13,	93,	1),
(13,	72,	1),
(13,	86,	1),
(13,	67,	1),
(13,	78,	1),
(13,	79,	1),
(13,	70,	1),
(13,	75,	1),
(13,	74,	1),
(13,	87,	1),
(13,	69,	1),
(13,	94,	1),
(13,	92,	1),
(13,	80,	1),
(13,	90,	1),
(13,	73,	1),
(13,	66,	1),
(14,	77,	2),
(14,	93,	2),
(14,	72,	2),
(14,	86,	2),
(14,	67,	2),
(14,	78,	2),
(14,	79,	2),
(14,	70,	2),
(14,	75,	2),
(14,	74,	2),
(14,	87,	2),
(14,	69,	2),
(14,	94,	2),
(14,	92,	2),
(14,	80,	2),
(14,	90,	2),
(14,	73,	2),
(14,	66,	2),
(31,	36,	1),
(31,	35,	1),
(31,	34,	1),
(31,	33,	1),
(31,	32,	1),
(31,	31,	1),
(31,	63,	1),
(31,	52,	1),
(31,	64,	1),
(31,	51,	1),
(31,	50,	1),
(31,	49,	1),
(31,	48,	1),
(31,	47,	1),
(31,	103,	1),
(31,	108,	1),
(31,	96,	1),
(31,	105,	1),
(8,	77,	2),
(8,	93,	2),
(8,	72,	2),
(8,	86,	2),
(8,	67,	2),
(8,	78,	2),
(8,	79,	2),
(8,	70,	2),
(8,	75,	2),
(8,	74,	2),
(8,	87,	2),
(8,	69,	2),
(8,	94,	2),
(8,	92,	2),
(8,	80,	2),
(8,	90,	2),
(8,	73,	2),
(8,	66,	2),
(9,	77,	3),
(9,	93,	3),
(9,	72,	3),
(9,	86,	3),
(9,	67,	3),
(9,	78,	3),
(9,	79,	3),
(9,	70,	3),
(9,	75,	3),
(9,	74,	3),
(9,	87,	3),
(9,	69,	3),
(9,	94,	3),
(9,	92,	3),
(9,	80,	3),
(9,	90,	3),
(9,	73,	3),
(9,	66,	3),
(37,	96,	1),
(37,	105,	1),
(37,	97,	1),
(37,	98,	1),
(37,	109,	1),
(37,	110,	1),
(37,	100,	1),
(37,	41,	1),
(37,	40,	1),
(37,	39,	1),
(37,	38,	1),
(36,	62,	1),
(36,	29,	1),
(36,	28,	1),
(36,	27,	1),
(36,	26,	1),
(36,	25,	1),
(36,	24,	1),
(19,	77,	1),
(19,	93,	1),
(19,	72,	1),
(19,	86,	1),
(19,	67,	1),
(19,	78,	1),
(19,	79,	1),
(19,	70,	1),
(19,	75,	1),
(19,	74,	1),
(19,	87,	1),
(19,	69,	1),
(19,	94,	1),
(19,	92,	1),
(19,	80,	1),
(19,	90,	1),
(19,	73,	1),
(19,	66,	1),
(9,	109,	3),
(9,	110,	3),
(9,	100,	3),
(8,	103,	2),
(8,	108,	2),
(8,	96,	2),
(8,	105,	2),
(8,	97,	2),
(8,	98,	2),
(8,	109,	2),
(8,	110,	2),
(8,	100,	2),
(31,	97,	1),
(31,	98,	1),
(31,	109,	1),
(31,	110,	1),
(31,	100,	1),
(31,	41,	1),
(31,	40,	1),
(31,	39,	1),
(31,	38,	1),
(14,	103,	2),
(14,	108,	2),
(14,	96,	2),
(14,	105,	2),
(14,	97,	2),
(14,	98,	2),
(14,	109,	2),
(14,	110,	2),
(14,	100,	2),
(13,	103,	1),
(13,	108,	1),
(13,	96,	1),
(13,	105,	1),
(13,	97,	1),
(13,	98,	1),
(38,	36,	1),
(38,	37,	1),
(38,	58,	1),
(38,	59,	1),
(38,	60,	1),
(38,	19,	1),
(38,	20,	1),
(38,	21,	1),
(38,	22,	1),
(38,	23,	1),
(38,	24,	1),
(38,	25,	1),
(38,	26,	1),
(38,	27,	1),
(38,	28,	1),
(38,	29,	1),
(38,	62,	1),
(39,	38,	1),
(39,	39,	1),
(39,	40,	1),
(39,	41,	1),
(39,	100,	1),
(39,	110,	1),
(39,	109,	1),
(39,	98,	1),
(39,	97,	1),
(39,	105,	1),
(39,	96,	1),
(39,	108,	1),
(39,	103,	1),
(39,	47,	1),
(39,	48,	1),
(39,	49,	1),
(39,	50,	1),
(39,	51,	1),
(39,	64,	1),
(39,	52,	1),
(39,	63,	1),
(39,	31,	1),
(39,	32,	1),
(39,	33,	1),
(39,	34,	1),
(39,	35,	1),
(39,	36,	1),
(39,	37,	1),
(39,	58,	1),
(39,	59,	1),
(39,	60,	1),
(39,	19,	1),
(39,	20,	1),
(39,	21,	1),
(39,	22,	1),
(39,	23,	1),
(39,	24,	1),
(39,	25,	1),
(39,	26,	1),
(39,	27,	1),
(39,	28,	1),
(39,	29,	1),
(39,	62,	1),
(40,	38,	2),
(40,	39,	2),
(40,	40,	2),
(40,	41,	2),
(40,	100,	2),
(40,	110,	2),
(40,	109,	2),
(40,	98,	2),
(40,	97,	2),
(40,	105,	2),
(40,	96,	2),
(40,	108,	2),
(40,	103,	2),
(40,	47,	2),
(40,	48,	2),
(40,	49,	2),
(40,	50,	2),
(40,	51,	2),
(40,	64,	2),
(40,	52,	2),
(40,	63,	2),
(40,	31,	2),
(40,	32,	2),
(40,	33,	2),
(40,	34,	2),
(40,	35,	2),
(40,	36,	2),
(40,	37,	2),
(40,	58,	2),
(40,	59,	2),
(40,	60,	2),
(40,	19,	2),
(40,	20,	2),
(40,	21,	2),
(40,	22,	2),
(40,	23,	2),
(40,	24,	2),
(40,	25,	2),
(40,	26,	2),
(40,	27,	2),
(40,	28,	2),
(40,	29,	2),
(40,	62,	2),
(43,	38,	1),
(43,	39,	1),
(43,	40,	1),
(43,	41,	1),
(43,	100,	1),
(43,	110,	1),
(43,	109,	1),
(43,	98,	1),
(43,	97,	1),
(43,	105,	1),
(43,	96,	1),
(43,	108,	1),
(43,	103,	1),
(43,	47,	1),
(43,	48,	1),
(43,	49,	1),
(43,	50,	1),
(43,	51,	1),
(43,	64,	1),
(43,	52,	1),
(43,	63,	1),
(43,	31,	1),
(43,	32,	1),
(43,	33,	1),
(43,	34,	1),
(43,	35,	1),
(43,	36,	1),
(43,	37,	1),
(43,	58,	1),
(43,	59,	1),
(43,	60,	1),
(43,	19,	1),
(43,	20,	1),
(43,	21,	1),
(43,	22,	1),
(43,	23,	1),
(43,	24,	1),
(43,	25,	1),
(43,	26,	1),
(43,	27,	1),
(43,	28,	1),
(43,	29,	1),
(43,	62,	1),
(16,	111,	1),
(11,	111,	1),
(5,	111,	1),
(6,	111,	2),
(20,	111,	1),
(17,	111,	1),
(15,	111,	1),
(13,	111,	1),
(14,	111,	2),
(8,	111,	1),
(9,	111,	2),
(19,	111,	1),
(31,	111,	1),
(11,	115,	1),
(34,	111,	1),
(35,	111,	2),
(36,	111,	1),
(37,	111,	1),
(39,	111,	1),
(40,	111,	2),
(43,	111,	1),
(45,	100,	1),
(16,	112,	1),
(11,	112,	1),
(5,	112,	1),
(6,	112,	2),
(20,	112,	1),
(17,	112,	1),
(15,	112,	1),
(13,	112,	1),
(14,	112,	2),
(8,	112,	1),
(9,	112,	2),
(19,	112,	1),
(31,	112,	1),
(11,	116,	1),
(34,	112,	1),
(35,	112,	2),
(36,	112,	1),
(37,	112,	1),
(38,	112,	1),
(39,	112,	1),
(40,	112,	2),
(43,	112,	1),
(16,	114,	1),
(16,	113,	1),
(11,	114,	1),
(11,	113,	1),
(5,	114,	1),
(5,	113,	1),
(6,	114,	2),
(6,	113,	2),
(20,	114,	1),
(20,	113,	1),
(17,	114,	1),
(17,	113,	1),
(15,	114,	1),
(15,	113,	1),
(13,	114,	1),
(13,	113,	1),
(14,	114,	2),
(14,	113,	2),
(8,	114,	1),
(8,	113,	1),
(9,	114,	2),
(9,	113,	2),
(19,	114,	1),
(19,	113,	1),
(31,	114,	1),
(31,	113,	1),
(16,	115,	1),
(16,	116,	1),
(34,	114,	1),
(34,	113,	1),
(35,	114,	2),
(35,	113,	2),
(36,	114,	1),
(36,	113,	1),
(37,	114,	1),
(37,	113,	1),
(39,	114,	1),
(39,	113,	1),
(40,	114,	2),
(40,	113,	2),
(43,	114,	1),
(43,	113,	1),
(46,	112,	1),
(46,	100,	1),
(46,	110,	1),
(46,	109,	1),
(46,	98,	1),
(46,	97,	1),
(46,	105,	1),
(46,	96,	1),
(46,	108,	1),
(46,	103,	1),
(46,	116,	1),
(46,	115,	1),
(46,	19,	1),
(46,	20,	1),
(46,	21,	1),
(46,	22,	1),
(46,	23,	1),
(46,	24,	1),
(46,	25,	1),
(46,	26,	1),
(46,	27,	1),
(46,	28,	1),
(46,	29,	1),
(46,	31,	1),
(46,	32,	1),
(46,	33,	1),
(46,	34,	1),
(46,	35,	1),
(46,	36,	1),
(46,	37,	1),
(46,	62,	1),
(46,	38,	1),
(46,	39,	1),
(46,	40,	1),
(46,	41,	1),
(46,	63,	1),
(46,	64,	1),
(46,	52,	1),
(46,	47,	1),
(46,	48,	1),
(46,	49,	1),
(46,	50,	1),
(46,	51,	1),
(46,	58,	1),
(46,	59,	1),
(46,	60,	1),
(46,	111,	1),
(16,	117,	1),
(11,	117,	1),
(5,	117,	1),
(6,	117,	2),
(20,	117,	1),
(17,	117,	1),
(15,	117,	1),
(13,	117,	1),
(14,	117,	2),
(8,	117,	1),
(9,	117,	2),
(19,	117,	1),
(31,	117,	1),
(46,	117,	1),
(34,	117,	1),
(35,	117,	2),
(36,	117,	1),
(37,	117,	1),
(39,	117,	1),
(40,	117,	2),
(43,	117,	1),
(16,	119,	1),
(16,	120,	1),
(16,	118,	1),
(11,	119,	1),
(11,	120,	1),
(11,	118,	1),
(5,	119,	1),
(5,	120,	1),
(5,	118,	1),
(6,	119,	2),
(6,	120,	2),
(6,	118,	2),
(20,	119,	1),
(20,	120,	1),
(20,	118,	1),
(17,	119,	1),
(17,	120,	1),
(17,	118,	1),
(15,	119,	1),
(15,	120,	1),
(15,	118,	1),
(13,	119,	1),
(13,	120,	1),
(13,	118,	1),
(14,	119,	2),
(14,	120,	2),
(14,	118,	2),
(8,	119,	1),
(8,	120,	1),
(8,	118,	1),
(9,	119,	2),
(9,	120,	2),
(9,	118,	2),
(19,	119,	1),
(19,	120,	1),
(19,	118,	1),
(31,	119,	1),
(31,	120,	1),
(31,	118,	1),
(46,	119,	1),
(46,	120,	1),
(46,	118,	1),
(34,	119,	1),
(34,	120,	1),
(34,	118,	1),
(35,	119,	2),
(35,	120,	2),
(35,	118,	2),
(36,	119,	1),
(36,	120,	1),
(36,	118,	1),
(37,	119,	1),
(37,	120,	1),
(37,	118,	1),
(39,	119,	1),
(39,	120,	1),
(39,	118,	1),
(40,	119,	2),
(40,	120,	2),
(40,	118,	2),
(43,	119,	1),
(43,	120,	1),
(43,	118,	1);

DROP TABLE IF EXISTS `qd_vi_blog_23`;
CREATE TABLE `qd_vi_blog_23` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) unsigned NOT NULL DEFAULT 0,
  `listcatid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `topicid` smallint(5) unsigned NOT NULL DEFAULT 0,
  `admin_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `author` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `sourceid` mediumint(8) NOT NULL DEFAULT 0,
  `addtime` int(11) unsigned NOT NULL DEFAULT 0,
  `edittime` int(11) unsigned NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `weight` int(11) unsigned NOT NULL DEFAULT 0,
  `publtime` int(11) unsigned NOT NULL DEFAULT 0,
  `exptime` int(11) unsigned NOT NULL DEFAULT 0,
  `archive` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hometext` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `homeimgfile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `homeimgalt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `homeimgthumb` tinyint(4) NOT NULL DEFAULT 0,
  `inhome` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `allowed_comm` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `allowed_rating` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `external_link` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hitstotal` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `hitscm` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `total_rating` int(11) NOT NULL DEFAULT 0,
  `click_rating` int(11) NOT NULL DEFAULT 0,
  `instant_active` tinyint(1) NOT NULL DEFAULT 0,
  `instant_template` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `instant_creatauto` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`),
  KEY `topicid` (`topicid`),
  KEY `admin_id` (`admin_id`),
  KEY `author` (`author`),
  KEY `title` (`title`),
  KEY `addtime` (`addtime`),
  KEY `edittime` (`edittime`),
  KEY `publtime` (`publtime`),
  KEY `exptime` (`exptime`),
  KEY `status` (`status`),
  KEY `instant_active` (`instant_active`),
  KEY `instant_creatauto` (`instant_creatauto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_23`;
INSERT INTO `qd_vi_blog_23` (`id`, `catid`, `listcatid`, `topicid`, `admin_id`, `author`, `sourceid`, `addtime`, `edittime`, `status`, `weight`, `publtime`, `exptime`, `archive`, `title`, `alias`, `hometext`, `homeimgfile`, `homeimgalt`, `homeimgthumb`, `inhome`, `allowed_comm`, `allowed_rating`, `external_link`, `hitstotal`, `hitscm`, `total_rating`, `click_rating`, `instant_active`, `instant_template`, `instant_creatauto`) VALUES
(66,	23,	'23',	0,	1,	'',	0,	1629364697,	1629364803,	1,	1,	1629364620,	0,	2,	'Bài viết đầu tiên',	'bai-viet-dau-tien',	'Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.',	'',	'',	0,	1,	'4',	1,	0,	2,	0,	0,	0,	0,	'',	0);

DROP TABLE IF EXISTS `qd_vi_blog_admins`;
CREATE TABLE `qd_vi_blog_admins` (
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `catid` smallint(5) NOT NULL DEFAULT 0,
  `admin` tinyint(4) NOT NULL DEFAULT 0,
  `add_content` tinyint(4) NOT NULL DEFAULT 0,
  `pub_content` tinyint(4) NOT NULL DEFAULT 0,
  `edit_content` tinyint(4) NOT NULL DEFAULT 0,
  `del_content` tinyint(4) NOT NULL DEFAULT 0,
  `app_content` tinyint(4) NOT NULL DEFAULT 0,
  UNIQUE KEY `userid` (`userid`,`catid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_admins`;

DROP TABLE IF EXISTS `qd_vi_blog_block`;
CREATE TABLE `qd_vi_blog_block` (
  `bid` smallint(5) unsigned NOT NULL,
  `id` int(11) unsigned NOT NULL,
  `weight` int(11) unsigned NOT NULL,
  UNIQUE KEY `bid` (`bid`,`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_block`;
INSERT INTO `qd_vi_blog_block` (`bid`, `id`, `weight`) VALUES
(2,	66,	1);

DROP TABLE IF EXISTS `qd_vi_blog_block_cat`;
CREATE TABLE `qd_vi_blog_block_cat` (
  `bid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `adddefault` tinyint(4) NOT NULL DEFAULT 0,
  `numbers` smallint(5) NOT NULL DEFAULT 10,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `weight` smallint(5) NOT NULL DEFAULT 0,
  `keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_time` int(11) NOT NULL DEFAULT 0,
  `edit_time` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`bid`),
  UNIQUE KEY `title` (`title`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_block_cat`;
INSERT INTO `qd_vi_blog_block_cat` (`bid`, `adddefault`, `numbers`, `title`, `alias`, `image`, `description`, `weight`, `keywords`, `add_time`, `edit_time`) VALUES
(1,	0,	4,	'Tin tiêu điểm',	'Tin-tieu-diem',	'',	'Tin tiêu điểm',	1,	'',	1279945710,	1279956943),
(2,	1,	4,	'Tin mới nhất',	'Tin-moi-nhat',	'',	'Tin mới nhất',	2,	'',	1279945725,	1279956445);

DROP TABLE IF EXISTS `qd_vi_blog_cat`;
CREATE TABLE `qd_vi_blog_cat` (
  `catid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `parentid` smallint(5) unsigned NOT NULL DEFAULT 0,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `titlesite` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `descriptionhtml` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `viewdescription` tinyint(2) NOT NULL DEFAULT 0,
  `weight` smallint(5) unsigned NOT NULL DEFAULT 0,
  `sort` smallint(5) NOT NULL DEFAULT 0,
  `lev` smallint(5) NOT NULL DEFAULT 0,
  `viewcat` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'viewcat_page_new',
  `numsubcat` smallint(5) NOT NULL DEFAULT 0,
  `subcatid` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `numlinks` tinyint(2) unsigned NOT NULL DEFAULT 3,
  `newday` tinyint(2) unsigned NOT NULL DEFAULT 2,
  `featured` int(11) NOT NULL DEFAULT 0,
  `ad_block_cat` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `admins` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_time` int(11) unsigned NOT NULL DEFAULT 0,
  `edit_time` int(11) unsigned NOT NULL DEFAULT 0,
  `groups_view` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `status` smallint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`catid`),
  UNIQUE KEY `alias` (`alias`),
  KEY `parentid` (`parentid`),
  KEY `status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_cat`;
INSERT INTO `qd_vi_blog_cat` (`catid`, `parentid`, `title`, `titlesite`, `alias`, `description`, `descriptionhtml`, `image`, `viewdescription`, `weight`, `sort`, `lev`, `viewcat`, `numsubcat`, `subcatid`, `numlinks`, `newday`, `featured`, `ad_block_cat`, `keywords`, `admins`, `add_time`, `edit_time`, `groups_view`, `status`) VALUES
(23,	0,	'Chuyên mục đầu tiên',	'',	'chuyen-muc-dau-tien',	'',	'',	'',	0,	1,	1,	0,	'viewcat_grid_new',	0,	'',	3,	2,	0,	'',	'',	'',	1629364582,	1629364715,	'6',	1);

DROP TABLE IF EXISTS `qd_vi_blog_config_post`;
CREATE TABLE `qd_vi_blog_config_post` (
  `group_id` smallint(5) NOT NULL,
  `addcontent` tinyint(4) NOT NULL,
  `postcontent` tinyint(4) NOT NULL,
  `editcontent` tinyint(4) NOT NULL,
  `delcontent` tinyint(4) NOT NULL,
  PRIMARY KEY (`group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_config_post`;
INSERT INTO `qd_vi_blog_config_post` (`group_id`, `addcontent`, `postcontent`, `editcontent`, `delcontent`) VALUES
(4,	0,	0,	0,	0),
(7,	0,	0,	0,	0),
(5,	0,	0,	0,	0);

DROP TABLE IF EXISTS `qd_vi_blog_detail`;
CREATE TABLE `qd_vi_blog_detail` (
  `id` int(11) unsigned NOT NULL,
  `titlesite` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `bodyhtml` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `sourcetext` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `files` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `imgposition` tinyint(1) NOT NULL DEFAULT 1,
  `layout_func` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `copyright` tinyint(1) NOT NULL DEFAULT 0,
  `allowed_send` tinyint(1) NOT NULL DEFAULT 0,
  `allowed_print` tinyint(1) NOT NULL DEFAULT 0,
  `allowed_save` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_detail`;
INSERT INTO `qd_vi_blog_detail` (`id`, `titlesite`, `description`, `bodyhtml`, `keywords`, `sourcetext`, `files`, `imgposition`, `layout_func`, `copyright`, `allowed_send`, `allowed_print`, `allowed_save`) VALUES
(66,	'',	'',	'<h3>The standard Lorem Ipsum passage, used since the 1500s</h3>\r\n\r\n<p>&quot;Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.&quot;</p>\r\n\r\n<h3>Section 1.10.32 of &quot;de Finibus Bonorum et Malorum&quot;, written by Cicero in 45 BC</h3>\r\n\r\n<p>&quot;Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?&quot;</p>\r\n\r\n<h3>1914 translation by H. Rackham</h3>\r\n\r\n<p>&quot;But I must explain to you how all this mistaken idea of denouncing pleasure and praising pain was born and I will give you a complete account of the system, and expound the actual teachings of the great explorer of the truth, the master-builder of human happiness. No one rejects, dislikes, or avoids pleasure itself, because it is pleasure, but because those who do not know how to pursue pleasure rationally encounter consequences that are extremely painful. Nor again is there anyone who loves or pursues or desires to obtain pain of itself, because it is pain, but because occasionally circumstances occur in which toil and pain can procure him some great pleasure. To take a trivial example, which of us ever undertakes laborious physical exercise, except to obtain some advantage from it? But who has any right to find fault with a man who chooses to enjoy a pleasure that has no annoying consequences, or one who avoids a pain that produces no resultant pleasure?&quot;</p>\r\n\r\n<h3>Section 1.10.33 of &quot;de Finibus Bonorum et Malorum&quot;, written by Cicero in 45 BC22</h3>\r\n\r\n<p>&quot;At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.&quot;</p>\r\n\r\n<h3>1914 translation by H. Rackham 2</h3>\r\n\r\n<p>&quot;On the other hand, we denounce with righteous indignation and dislike men who are so beguiled and demoralized by the charms of pleasure of the moment, so blinded by desire, that they cannot foresee the pain and trouble that are bound to ensue; and equal blame belongs to those who fail in their duty through weakness of will, which is the same as saying through shrinking from toil and pain. These cases are perfectly simple and easy to distinguish. In a free hour, when our power of choice is untrammelled and when nothing prevents our being able to do what we like best, every pleasure is to be welcomed and every pain avoided. But in certain circumstances and owing to the claims of duty or the obligations of business it will frequently occur that pleasures have to be repudiated and annoyances accepted. The wise man therefore always holds in these matters to this principle of selection: he rejects pleasures to secure other greater pleasures, or else he endures pains to avoid worse pains.&quot;</p>',	'',	'',	'',	2,	'',	0,	1,	1,	1);

DROP TABLE IF EXISTS `qd_vi_blog_logs`;
CREATE TABLE `qd_vi_blog_logs` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `sid` mediumint(8) NOT NULL DEFAULT 0,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 0,
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `set_time` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `sid` (`sid`),
  KEY `userid` (`userid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_logs`;

DROP TABLE IF EXISTS `qd_vi_blog_rows`;
CREATE TABLE `qd_vi_blog_rows` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `catid` smallint(5) unsigned NOT NULL DEFAULT 0,
  `listcatid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `topicid` smallint(5) unsigned NOT NULL DEFAULT 0,
  `admin_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `author` varchar(250) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `sourceid` mediumint(8) NOT NULL DEFAULT 0,
  `addtime` int(11) unsigned NOT NULL DEFAULT 0,
  `edittime` int(11) unsigned NOT NULL DEFAULT 0,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `weight` int(11) unsigned NOT NULL DEFAULT 0,
  `publtime` int(11) unsigned NOT NULL DEFAULT 0,
  `exptime` int(11) unsigned NOT NULL DEFAULT 0,
  `archive` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hometext` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `homeimgfile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `homeimgalt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `homeimgthumb` tinyint(4) NOT NULL DEFAULT 0,
  `inhome` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `allowed_comm` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `allowed_rating` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `external_link` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hitstotal` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `hitscm` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `total_rating` int(11) NOT NULL DEFAULT 0,
  `click_rating` int(11) NOT NULL DEFAULT 0,
  `instant_active` tinyint(1) NOT NULL DEFAULT 0,
  `instant_template` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `instant_creatauto` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `catid` (`catid`),
  KEY `topicid` (`topicid`),
  KEY `admin_id` (`admin_id`),
  KEY `author` (`author`),
  KEY `title` (`title`),
  KEY `addtime` (`addtime`),
  KEY `edittime` (`edittime`),
  KEY `publtime` (`publtime`),
  KEY `exptime` (`exptime`),
  KEY `status` (`status`),
  KEY `instant_active` (`instant_active`),
  KEY `instant_creatauto` (`instant_creatauto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_rows`;
INSERT INTO `qd_vi_blog_rows` (`id`, `catid`, `listcatid`, `topicid`, `admin_id`, `author`, `sourceid`, `addtime`, `edittime`, `status`, `weight`, `publtime`, `exptime`, `archive`, `title`, `alias`, `hometext`, `homeimgfile`, `homeimgalt`, `homeimgthumb`, `inhome`, `allowed_comm`, `allowed_rating`, `external_link`, `hitstotal`, `hitscm`, `total_rating`, `click_rating`, `instant_active`, `instant_template`, `instant_creatauto`) VALUES
(66,	23,	'23',	0,	1,	'',	0,	1629364697,	1629364803,	1,	1,	1629364620,	0,	2,	'Bài viết đầu tiên',	'bai-viet-dau-tien',	'Contrary to popular belief, Lorem Ipsum is not simply random text. It has roots in a piece of classical Latin literature from 45 BC, making it over 2000 years old. Richard McClintock, a Latin professor at Hampden-Sydney College in Virginia, looked up one of the more obscure Latin words, consectetur, from a Lorem Ipsum passage, and going through the cites of the word in classical literature, discovered the undoubtable source.',	'',	'',	0,	1,	'4',	1,	0,	2,	0,	0,	0,	0,	'',	0);

DROP TABLE IF EXISTS `qd_vi_blog_sources`;
CREATE TABLE `qd_vi_blog_sources` (
  `sourceid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `logo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `weight` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `add_time` int(11) unsigned NOT NULL,
  `edit_time` int(11) unsigned NOT NULL,
  PRIMARY KEY (`sourceid`),
  UNIQUE KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_sources`;
INSERT INTO `qd_vi_blog_sources` (`sourceid`, `title`, `link`, `logo`, `weight`, `add_time`, `edit_time`) VALUES
(1,	'Báo Hà Nội Mới',	'http://hanoimoi.com.vn',	'',	1,	1274989177,	1274989177),
(2,	'VINADES.,JSC',	'http://vinades.vn',	'',	2,	1274989787,	1274989787),
(3,	'Báo điện tử Dân Trí',	'http://dantri.com.vn',	'',	3,	1322685396,	1322685396),
(4,	'Bộ Thông tin và Truyền thông',	'http://http://mic.gov.vn',	'',	4,	1445309676,	1445309676),
(5,	'vietcetera.com',	'https://vietcetera.com',	'',	5,	1598448334,	1598448334),
(6,	'Medium',	'',	'',	6,	1626144938,	1626144938),
(7,	'LifeHack',	'',	'',	7,	1626364557,	1626364557),
(8,	'nukeviet.vn',	'',	'',	8,	1626745400,	1626745400),
(9,	'dayhocstem',	'',	'',	9,	1628753086,	1628753086);

DROP TABLE IF EXISTS `qd_vi_blog_tags`;
CREATE TABLE `qd_vi_blog_tags` (
  `tid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `numnews` mediumint(8) NOT NULL DEFAULT 0,
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `keywords` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`tid`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_tags`;

DROP TABLE IF EXISTS `qd_vi_blog_tags_id`;
CREATE TABLE `qd_vi_blog_tags_id` (
  `id` int(11) NOT NULL,
  `tid` mediumint(9) NOT NULL,
  `keyword` varchar(65) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `id_tid` (`id`,`tid`),
  KEY `tid` (`tid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_tags_id`;

DROP TABLE IF EXISTS `qd_vi_blog_tmp`;
CREATE TABLE `qd_vi_blog_tmp` (
  `id` mediumint(8) unsigned NOT NULL,
  `admin_id` int(11) NOT NULL DEFAULT 0,
  `time_edit` int(11) NOT NULL,
  `time_late` int(11) NOT NULL,
  `ip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_tmp`;
INSERT INTO `qd_vi_blog_tmp` (`id`, `admin_id`, `time_edit`, `time_late`, `ip`) VALUES
(66,	1,	1629365354,	1629365365,	'127.0.0.1');

DROP TABLE IF EXISTS `qd_vi_blog_topics`;
CREATE TABLE `qd_vi_blog_topics` (
  `topicid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `bodyhtml` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `weight` smallint(5) NOT NULL DEFAULT 0,
  `keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `add_time` int(11) NOT NULL DEFAULT 0,
  `edit_time` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`topicid`),
  UNIQUE KEY `title` (`title`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_blog_topics`;

DROP TABLE IF EXISTS `qd_vi_comment`;
CREATE TABLE `qd_vi_comment` (
  `cid` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `module` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `area` int(11) NOT NULL DEFAULT 0,
  `id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `pid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attach` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `post_time` int(11) unsigned NOT NULL DEFAULT 0,
  `userid` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `post_name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_email` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `post_ip` varchar(39) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `likes` mediumint(9) NOT NULL DEFAULT 0,
  `dislikes` mediumint(9) NOT NULL DEFAULT 0,
  PRIMARY KEY (`cid`),
  KEY `mod_id` (`module`,`area`,`id`),
  KEY `post_time` (`post_time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_comment`;

DROP TABLE IF EXISTS `qd_vi_menu`;
CREATE TABLE `qd_vi_menu` (
  `id` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_menu`;
INSERT INTO `qd_vi_menu` (`id`, `title`) VALUES
(1,	'Top Menu'),
(2,	'Top header');

DROP TABLE IF EXISTS `qd_vi_menu_rows`;
CREATE TABLE `qd_vi_menu_rows` (
  `id` mediumint(5) NOT NULL AUTO_INCREMENT,
  `parentid` mediumint(5) unsigned NOT NULL,
  `mid` smallint(5) NOT NULL DEFAULT 0,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `icon` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `weight` int(11) NOT NULL,
  `sort` int(11) NOT NULL DEFAULT 0,
  `lev` int(11) NOT NULL DEFAULT 0,
  `subitem` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups_view` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `module_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `op` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `target` tinyint(4) DEFAULT 0,
  `css` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `active_type` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `parentid` (`parentid`,`mid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_menu_rows`;
INSERT INTO `qd_vi_menu_rows` (`id`, `parentid`, `mid`, `title`, `link`, `icon`, `image`, `note`, `weight`, `sort`, `lev`, `subitem`, `groups_view`, `module_name`, `op`, `target`, `css`, `active_type`, `status`) VALUES
(40,	0,	2,	'Blog',	'/index.php?language=vi&nv=blog',	'',	'',	'',	1,	1,	0,	'',	'6',	'blog',	'',	1,	'',	0,	1),
(39,	0,	1,	'Chuyên mục đầu tiên',	'/index.php?language=vi&nv=blog&op=chuyen-muc-dau-tien',	'',	'',	'',	1,	1,	0,	'',	'6',	'blog',	'',	1,	'',	0,	1);

DROP TABLE IF EXISTS `qd_vi_modfuncs`;
CREATE TABLE `qd_vi_modfuncs` (
  `func_id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `func_name` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(55) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `func_custom_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `func_site_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `in_module` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `show_func` tinyint(4) NOT NULL DEFAULT 0,
  `in_submenu` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `subweight` smallint(2) unsigned NOT NULL DEFAULT 1,
  `setting` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`func_id`),
  UNIQUE KEY `func_name` (`func_name`,`in_module`),
  UNIQUE KEY `alias` (`alias`,`in_module`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_modfuncs`;
INSERT INTO `qd_vi_modfuncs` (`func_id`, `func_name`, `alias`, `func_custom_name`, `func_site_title`, `in_module`, `show_func`, `in_submenu`, `subweight`, `setting`) VALUES
(19,	'main',	'main',	'Main',	'',	'users',	1,	0,	1,	''),
(20,	'login',	'login',	'Đăng nhập',	'',	'users',	1,	1,	2,	''),
(21,	'register',	'register',	'Đăng ký',	'',	'users',	1,	1,	3,	''),
(22,	'lostpass',	'lostpass',	'Khôi phục mật khẩu',	'',	'users',	1,	1,	4,	''),
(23,	'active',	'active',	'Kích hoạt tài khoản',	'',	'users',	1,	0,	5,	''),
(24,	'lostactivelink',	'lostactivelink',	'Lostactivelink',	'',	'users',	1,	0,	6,	''),
(25,	'editinfo',	'editinfo',	'Thiết lập tài khoản',	'',	'users',	1,	1,	7,	''),
(26,	'memberlist',	'memberlist',	'Danh sách thành viên',	'',	'users',	1,	1,	8,	''),
(27,	'avatar',	'avatar',	'Avatar',	'',	'users',	1,	0,	9,	''),
(28,	'logout',	'logout',	'Thoát',	'',	'users',	1,	1,	10,	''),
(29,	'groups',	'groups',	'Quản lý nhóm',	'',	'users',	1,	0,	11,	''),
(30,	'oauth',	'oauth',	'Oauth',	'',	'users',	0,	0,	0,	''),
(31,	'main',	'main',	'Main',	'',	'statistics',	1,	0,	1,	''),
(32,	'allreferers',	'allreferers',	'Theo đường dẫn đến site',	'',	'statistics',	1,	1,	2,	''),
(33,	'allcountries',	'allcountries',	'Theo quốc gia',	'',	'statistics',	1,	1,	3,	''),
(34,	'allbrowsers',	'allbrowsers',	'Theo trình duyệt',	'',	'statistics',	1,	1,	4,	''),
(35,	'allos',	'allos',	'Theo hệ điều hành',	'',	'statistics',	1,	1,	5,	''),
(36,	'allbots',	'allbots',	'Theo máy chủ tìm kiếm',	'',	'statistics',	1,	1,	6,	''),
(37,	'referer',	'referer',	'Đường dẫn đến site theo tháng',	'',	'statistics',	1,	0,	7,	''),
(38,	'main',	'main',	'Main',	'',	'banners',	1,	0,	1,	''),
(39,	'addads',	'addads',	'Addads',	'',	'banners',	1,	0,	2,	''),
(40,	'clientinfo',	'clientinfo',	'Clientinfo',	'',	'banners',	1,	0,	3,	''),
(41,	'stats',	'stats',	'Stats',	'',	'banners',	1,	0,	4,	''),
(42,	'cledit',	'cledit',	'Cledit',	'',	'banners',	0,	0,	0,	''),
(43,	'click',	'click',	'Click',	'',	'banners',	0,	0,	0,	''),
(44,	'clinfo',	'clinfo',	'Clinfo',	'',	'banners',	0,	0,	0,	''),
(45,	'logininfo',	'logininfo',	'Logininfo',	'',	'banners',	0,	0,	0,	''),
(46,	'viewmap',	'viewmap',	'Viewmap',	'',	'banners',	0,	0,	0,	''),
(47,	'main',	'main',	'main',	'',	'comment',	1,	0,	1,	''),
(48,	'post',	'post',	'post',	'',	'comment',	1,	0,	2,	''),
(49,	'like',	'like',	'Like',	'',	'comment',	1,	0,	3,	''),
(50,	'delete',	'delete',	'Delete',	'',	'comment',	1,	0,	4,	''),
(51,	'down',	'down',	'Down',	'',	'comment',	1,	0,	5,	''),
(52,	'main',	'main',	'Main',	'',	'page',	1,	0,	1,	''),
(53,	'sitemap',	'sitemap',	'Sitemap',	'',	'page',	0,	0,	0,	''),
(54,	'rss',	'rss',	'Rss',	'',	'page',	0,	0,	0,	''),
(58,	'main',	'main',	'Main',	'',	'two-step-verification',	1,	0,	1,	''),
(59,	'confirm',	'confirm',	'Confirm',	'',	'two-step-verification',	1,	0,	2,	''),
(60,	'setup',	'setup',	'Setup',	'',	'two-step-verification',	1,	0,	3,	''),
(62,	'main',	'main',	'Main',	'',	'voting',	1,	0,	1,	''),
(63,	'main',	'main',	'Main',	'',	'seek',	1,	0,	1,	''),
(64,	'main',	'main',	'Main',	'',	'feeds',	1,	0,	1,	''),
(110,	'viewcat',	'viewcat',	'Viewcat',	'',	'blog',	1,	0,	2,	''),
(109,	'topic',	'topic',	'Topic',	'',	'blog',	1,	0,	3,	''),
(108,	'tag',	'tag',	'Tag',	'',	'blog',	1,	0,	8,	''),
(107,	'sitemap',	'sitemap',	'Sitemap',	'',	'blog',	0,	0,	0,	''),
(106,	'sendmail',	'sendmail',	'Sendmail',	'',	'blog',	0,	0,	0,	''),
(105,	'search',	'search',	'Search',	'',	'blog',	1,	1,	6,	''),
(104,	'savefile',	'savefile',	'Savefile',	'',	'blog',	0,	0,	0,	''),
(103,	'rss',	'rss',	'Rss',	'',	'blog',	1,	1,	9,	''),
(102,	'rating',	'rating',	'Rating',	'',	'blog',	0,	0,	0,	''),
(101,	'print',	'print',	'Print',	'',	'blog',	0,	0,	0,	''),
(100,	'main',	'main',	'Main',	'',	'blog',	1,	0,	1,	''),
(99,	'instant-rss',	'instant-rss',	'Instant-rss',	'',	'blog',	0,	0,	0,	''),
(98,	'groups',	'groups',	'Groups',	'',	'blog',	1,	0,	4,	''),
(97,	'detail',	'detail',	'Detail',	'',	'blog',	1,	0,	5,	''),
(96,	'content',	'content',	'Content',	'',	'blog',	1,	1,	7,	''),
(112,	'main',	'main',	'Main',	'',	'home',	1,	0,	1,	''),
(116,	'main',	'main',	'Main',	'',	'newsnotice',	1,	1,	1,	''),
(115,	'checkmail',	'checkmail',	'Checkmail',	'',	'newsnotice',	1,	0,	2,	'');

DROP TABLE IF EXISTS `qd_vi_modthemes`;
CREATE TABLE `qd_vi_modthemes` (
  `func_id` mediumint(8) DEFAULT NULL,
  `layout` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `theme` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  UNIQUE KEY `func_id` (`func_id`,`layout`,`theme`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_modthemes`;
INSERT INTO `qd_vi_modthemes` (`func_id`, `layout`, `theme`) VALUES
(0,	'left-main-right',	'default'),
(0,	'left-main-right',	'huynhquocdat'),
(19,	'left-main-right',	'default'),
(19,	'main',	'huynhquocdat'),
(20,	'left-main-right',	'default'),
(20,	'main',	'huynhquocdat'),
(21,	'left-main-right',	'default'),
(21,	'main',	'huynhquocdat'),
(22,	'left-main-right',	'default'),
(22,	'main',	'huynhquocdat'),
(23,	'left-main-right',	'default'),
(23,	'main',	'huynhquocdat'),
(24,	'left-main-right',	'default'),
(24,	'main',	'huynhquocdat'),
(25,	'left-main',	'default'),
(25,	'main',	'huynhquocdat'),
(26,	'left-main-right',	'default'),
(26,	'main',	'huynhquocdat'),
(27,	'left-main-right',	'default'),
(27,	'main',	'huynhquocdat'),
(28,	'left-main-right',	'default'),
(28,	'main',	'huynhquocdat'),
(29,	'left-main',	'default'),
(29,	'main',	'huynhquocdat'),
(31,	'left-main',	'default'),
(31,	'main',	'huynhquocdat'),
(32,	'left-main',	'default'),
(32,	'main',	'huynhquocdat'),
(33,	'left-main',	'default'),
(33,	'main',	'huynhquocdat'),
(34,	'left-main',	'default'),
(34,	'main',	'huynhquocdat'),
(35,	'left-main',	'default'),
(35,	'main',	'huynhquocdat'),
(36,	'left-main',	'default'),
(36,	'main',	'huynhquocdat'),
(37,	'left-main',	'default'),
(37,	'main',	'huynhquocdat'),
(38,	'left-main-right',	'default'),
(38,	'main',	'huynhquocdat'),
(39,	'left-main-right',	'default'),
(39,	'main',	'huynhquocdat'),
(40,	'left-main-right',	'default'),
(40,	'main',	'huynhquocdat'),
(41,	'left-main-right',	'default'),
(41,	'main',	'huynhquocdat'),
(47,	'left-main-right',	'default'),
(47,	'main',	'huynhquocdat'),
(48,	'left-main-right',	'default'),
(48,	'main',	'huynhquocdat'),
(49,	'left-main-right',	'default'),
(49,	'main',	'huynhquocdat'),
(50,	'left-main-right',	'default'),
(50,	'main',	'huynhquocdat'),
(51,	'main',	'huynhquocdat'),
(52,	'left-main',	'default'),
(52,	'main',	'huynhquocdat'),
(58,	'left-main-right',	'default'),
(58,	'main',	'huynhquocdat'),
(59,	'left-main-right',	'default'),
(59,	'main',	'huynhquocdat'),
(60,	'left-main-right',	'default'),
(60,	'main',	'huynhquocdat'),
(62,	'left-main',	'default'),
(62,	'main',	'huynhquocdat'),
(63,	'left-main-right',	'default'),
(63,	'main',	'huynhquocdat'),
(64,	'left-main-right',	'default'),
(64,	'main',	'huynhquocdat'),
(96,	'left-main-right',	'default'),
(96,	'main',	'huynhquocdat'),
(97,	'left-main-right',	'default'),
(97,	'main',	'huynhquocdat'),
(98,	'left-main-right',	'default'),
(98,	'main',	'huynhquocdat'),
(99,	'left-main-right',	'default'),
(100,	'left-main-right',	'default'),
(100,	'main',	'huynhquocdat'),
(101,	'left-main-right',	'default'),
(102,	'left-main-right',	'default'),
(103,	'left-main-right',	'default'),
(103,	'main',	'huynhquocdat'),
(104,	'left-main-right',	'default'),
(105,	'left-main-right',	'default'),
(105,	'main',	'huynhquocdat'),
(106,	'left-main-right',	'default'),
(107,	'left-main-right',	'default'),
(108,	'left-main-right',	'default'),
(108,	'main',	'huynhquocdat'),
(109,	'left-main-right',	'default'),
(109,	'main',	'huynhquocdat'),
(110,	'left-main-right',	'default'),
(110,	'main',	'huynhquocdat'),
(112,	'home',	'huynhquocdat'),
(112,	'left-main-right',	'default'),
(115,	'left-main-right',	'default'),
(115,	'main',	'huynhquocdat'),
(116,	'left-main-right',	'default'),
(116,	'main',	'huynhquocdat');

DROP TABLE IF EXISTS `qd_vi_modules`;
CREATE TABLE `qd_vi_modules` (
  `title` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `module_file` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module_data` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module_upload` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `module_theme` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `custom_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `site_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `admin_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `set_time` int(11) unsigned NOT NULL DEFAULT 0,
  `main_file` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `admin_file` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `theme` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `mobile` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `description` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `groups_view` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `weight` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `act` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `admins` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `rss` tinyint(4) NOT NULL DEFAULT 1,
  `sitemap` tinyint(4) NOT NULL DEFAULT 1,
  PRIMARY KEY (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_modules`;
INSERT INTO `qd_vi_modules` (`title`, `module_file`, `module_data`, `module_upload`, `module_theme`, `custom_title`, `site_title`, `admin_title`, `set_time`, `main_file`, `admin_file`, `theme`, `mobile`, `description`, `keywords`, `groups_view`, `weight`, `act`, `admins`, `rss`, `sitemap`) VALUES
('users',	'users',	'users',	'users',	'users',	'Thành viên',	'',	'Tài khoản',	1596205058,	1,	1,	'',	'',	'',	'',	'6',	4,	1,	'',	0,	1),
('statistics',	'statistics',	'statistics',	'statistics',	'statistics',	'Thống kê',	'',	'',	1596205058,	1,	1,	'',	'',	'',	'online, statistics',	'6',	5,	1,	'',	0,	1),
('voting',	'voting',	'voting',	'voting',	'voting',	'Thăm dò ý kiến',	'',	'',	1596205058,	1,	1,	'',	'',	'',	'',	'6',	6,	1,	'',	1,	1),
('banners',	'banners',	'banners',	'banners',	'banners',	'Quảng cáo',	'',	'',	1596205058,	1,	1,	'',	'',	'',	'',	'6',	7,	1,	'',	0,	1),
('seek',	'seek',	'seek',	'seek',	'seek',	'Tìm kiếm',	'',	'',	1596205058,	1,	0,	'',	'',	'',	'',	'6',	8,	1,	'',	0,	1),
('menu',	'menu',	'menu',	'menu',	'menu',	'Menu Site',	'',	'',	1596205058,	0,	1,	'',	'',	'',	'',	'6',	9,	1,	'',	0,	1),
('feeds',	'feeds',	'feeds',	'feeds',	'feeds',	'RSS-feeds',	'',	'RSS-feeds',	1596205058,	1,	1,	'',	'',	'',	'',	'6',	10,	1,	'',	0,	1),
('page',	'page',	'page',	'page',	'page',	'Page',	'',	'',	1596205058,	1,	1,	'',	'',	'',	'',	'6',	11,	1,	'',	1,	0),
('comment',	'comment',	'comment',	'comment',	'comment',	'Bình luận',	'',	'Quản lý bình luận',	1596205058,	0,	1,	'',	'',	'',	'',	'6',	12,	1,	'',	0,	1),
('two-step-verification',	'two-step-verification',	'two_step_verification',	'two_step_verification',	'two-step-verification',	'Xác thực hai bước',	'',	'',	1596205058,	1,	0,	'',	'',	'',	'',	'6',	13,	1,	'',	0,	1),
('blog',	'news',	'blog',	'blog',	'news',	'Blog',	'',	'',	1598170322,	1,	1,	'',	'',	'',	'',	'6',	2,	1,	'',	1,	1),
('home',	'home',	'home',	'home',	'home',	'Trang chủ',	'',	'',	1625823045,	1,	0,	'',	'',	'',	'',	'6',	1,	1,	'',	0,	0),
('newsnotice',	'newsnotice',	'newsnotice',	'newsnotice',	'newsnotice',	'Đăng ký nhận tin',	'',	'',	1626340879,	1,	1,	'',	'',	'',	'',	'6',	3,	1,	'',	0,	0);

DROP TABLE IF EXISTS `qd_vi_newsnotice`;
CREATE TABLE `qd_vi_newsnotice` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `listid` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_stacked` int(11) NOT NULL DEFAULT 0,
  `time_sended` int(11) DEFAULT 0,
  `listsended` mediumtext COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `totalsended` int(4) DEFAULT 0,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_newsnotice`;

DROP TABLE IF EXISTS `qd_vi_newsnotice_config`;
CREATE TABLE `qd_vi_newsnotice_config` (
  `config_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `config_name` (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_newsnotice_config`;
INSERT INTO `qd_vi_newsnotice_config` (`config_name`, `config_value`) VALUES
('active',	'1'),
('title_email',	'Tin tức mới'),
('numperpage',	'20'),
('active_required',	'1'),
('active_thank',	'1');

DROP TABLE IF EXISTS `qd_vi_newsnotice_emaillist`;
CREATE TABLE `qd_vi_newsnotice_emaillist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL,
  `time_reg` int(11) NOT NULL DEFAULT 0,
  `time_active` int(11) NOT NULL,
  `check_key` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `status` tinyint(4) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_newsnotice_emaillist`;

DROP TABLE IF EXISTS `qd_vi_page`;
CREATE TABLE `qd_vi_page` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `imagealt` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `imageposition` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `description` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `bodytext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `keywords` text COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `socialbutton` tinyint(4) NOT NULL DEFAULT 0,
  `activecomm` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `layout_func` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `weight` smallint(4) NOT NULL DEFAULT 0,
  `admin_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `add_time` int(11) NOT NULL DEFAULT 0,
  `edit_time` int(11) NOT NULL DEFAULT 0,
  `status` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `hitstotal` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `hot_post` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `alias` (`alias`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_page`;

DROP TABLE IF EXISTS `qd_vi_page_config`;
CREATE TABLE `qd_vi_page_config` (
  `config_name` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL,
  `config_value` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  UNIQUE KEY `config_name` (`config_name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_page_config`;
INSERT INTO `qd_vi_page_config` (`config_name`, `config_value`) VALUES
('viewtype',	'0'),
('facebookapi',	''),
('per_page',	'20'),
('news_first',	'0'),
('related_articles',	'5'),
('copy_page',	'0'),
('alias_lower',	'1');

DROP TABLE IF EXISTS `qd_vi_referer_stats`;
CREATE TABLE `qd_vi_referer_stats` (
  `host` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` int(11) NOT NULL DEFAULT 0,
  `month01` int(11) NOT NULL DEFAULT 0,
  `month02` int(11) NOT NULL DEFAULT 0,
  `month03` int(11) NOT NULL DEFAULT 0,
  `month04` int(11) NOT NULL DEFAULT 0,
  `month05` int(11) NOT NULL DEFAULT 0,
  `month06` int(11) NOT NULL DEFAULT 0,
  `month07` int(11) NOT NULL DEFAULT 0,
  `month08` int(11) NOT NULL DEFAULT 0,
  `month09` int(11) NOT NULL DEFAULT 0,
  `month10` int(11) NOT NULL DEFAULT 0,
  `month11` int(11) NOT NULL DEFAULT 0,
  `month12` int(11) NOT NULL DEFAULT 0,
  `last_update` int(11) NOT NULL DEFAULT 0,
  UNIQUE KEY `host` (`host`),
  KEY `total` (`total`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_referer_stats`;

DROP TABLE IF EXISTS `qd_vi_searchkeys`;
CREATE TABLE `qd_vi_searchkeys` (
  `id` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `skey` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `total` int(11) NOT NULL DEFAULT 0,
  `search_engine` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  KEY `id` (`id`),
  KEY `skey` (`skey`),
  KEY `search_engine` (`search_engine`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_searchkeys`;

DROP TABLE IF EXISTS `qd_vi_voting`;
CREATE TABLE `qd_vi_voting` (
  `vid` smallint(5) unsigned NOT NULL AUTO_INCREMENT,
  `question` varchar(250) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `acceptcm` int(2) NOT NULL DEFAULT 1,
  `active_captcha` tinyint(1) unsigned NOT NULL DEFAULT 0,
  `admin_id` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `groups_view` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `publ_time` int(11) unsigned NOT NULL DEFAULT 0,
  `exp_time` int(11) unsigned NOT NULL DEFAULT 0,
  `act` tinyint(1) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`vid`),
  UNIQUE KEY `question` (`question`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_voting`;
INSERT INTO `qd_vi_voting` (`vid`, `question`, `link`, `acceptcm`, `active_captcha`, `admin_id`, `groups_view`, `publ_time`, `exp_time`, `act`) VALUES
(2,	'Bạn biết gì về NukeViet 4?',	'',	1,	0,	1,	'6',	1275318563,	0,	1),
(3,	'Lợi ích của phần mềm nguồn mở là gì?',	'',	1,	0,	1,	'6',	1275318563,	0,	1);

DROP TABLE IF EXISTS `qd_vi_voting_rows`;
CREATE TABLE `qd_vi_voting_rows` (
  `id` mediumint(8) unsigned NOT NULL AUTO_INCREMENT,
  `vid` smallint(5) unsigned NOT NULL,
  `title` varchar(245) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `url` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `hitstotal` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `vid` (`vid`,`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

TRUNCATE `qd_vi_voting_rows`;
INSERT INTO `qd_vi_voting_rows` (`id`, `vid`, `title`, `url`, `hitstotal`) VALUES
(5,	2,	'Một bộ sourcecode cho web hoàn toàn mới.',	'',	0),
(6,	2,	'Mã nguồn mở, sử dụng miễn phí.',	'',	0),
(7,	2,	'Sử dụng HTML5, CSS3 và hỗ trợ Ajax',	'',	0),
(8,	2,	'Tất cả các ý kiến trên',	'',	0),
(9,	3,	'Liên tục được cải tiến, sửa đổi bởi cả thế giới.',	'',	0),
(10,	3,	'Được sử dụng miễn phí không mất tiền.',	'',	0),
(11,	3,	'Được tự do khám phá, sửa đổi theo ý thích.',	'',	0),
(12,	3,	'Phù hợp để học tập, nghiên cứu vì được tự do sửa đổi theo ý thích.',	'',	0),
(13,	3,	'Tất cả các ý kiến trên',	'',	0);

-- 2021-08-19 09:58:44
